/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.particles.paradoxparticle;

import com.direwolf20.justdirethings.client.particles.paradoxparticle.ParadoxParticleData;
import com.direwolf20.justdirethings.common.entities.ParadoxEntity;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ParadoxParticle
extends BreakingItemParticle {
    private double targetX;
    private double targetY;
    private double targetZ;
    private static Random random = new Random();
    private double initialRadius;
    private double angularVelocity;
    private double currentAngle;
    private double currentRadius;
    private double gravitationalPull;
    private UUID paradox_uuid;
    private boolean dying = false;
    private final BlockPos sourcePos;
    public static ParticleProvider<ParadoxParticleData> FACTORY = (data, world, x, y, z, xSpeed, ySpeed, zSpeed) -> new ParadoxParticle(world, x, y, z, data.targetX, data.targetY, data.targetZ, data.getItemStack(), data.ticksPerBlock, data.paradox_uuid);

    public ParadoxParticle(ClientLevel world, double x, double y, double z, double targetX, double targetY, double targetZ, ItemStack itemStack, int gravitationalPull, UUID paradox_uuid) {
        super(world, x, y, z, itemStack);
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
        this.gravitationalPull = gravitationalPull;
        this.paradox_uuid = paradox_uuid;
        this.currentRadius = this.initialRadius = Math.sqrt(Math.pow(targetX - x, 2.0) + Math.pow(targetY - y, 2.0) + Math.pow(targetZ - z, 2.0));
        this.angularVelocity = 0.0;
        this.currentAngle = 0.0;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.gravity = 0.0f;
        this.hasPhysics = false;
        this.lifetime = (int)(this.initialRadius * 20.0 / (double)gravitationalPull);
        if (this.sprite == null) {
            this.setSprite(Minecraft.getInstance().getItemRenderer().getModel(new ItemStack((ItemLike)Blocks.COBBLESTONE), (Level)world, null, 0).getParticleIcon());
        }
        this.sourcePos = new BlockPos((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
        BlockState blockState = this.level.getBlockState(this.sourcePos);
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            FluidStack fluidStack = new FluidStack((Fluid)liquidBlock.fluid, 1000);
            this.setSprite((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack)));
            int i = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
            this.rCol *= (float)(i >> 16 & 0xFF) / 255.0f;
            this.gCol *= (float)(i >> 8 & 0xFF) / 255.0f;
            this.bCol *= (float)(i & 0xFF) / 255.0f;
        }
        this.scale(0.5f);
        this.lifetime = 600;
    }

    public ParadoxParticle(ClientLevel world, double x, double y, double z, ItemStack itemStack) {
        super(world, x, y, z, itemStack);
        this.sourcePos = new BlockPos((int)x, (int)y, (int)z);
    }

    @Nullable
    private ParadoxEntity findEntityByUUID(ClientLevel world, UUID uuid) {
        for (Entity entity : world.entitiesForRendering()) {
            if (!entity.getUUID().equals(uuid) || !(entity instanceof ParadoxEntity)) continue;
            ParadoxEntity paradoxEntity = (ParadoxEntity)entity;
            return paradoxEntity;
        }
        return null;
    }

    public void deathMovement() {
        if (!this.onGround) {
            this.xd *= 0.5;
            this.zd *= 0.5;
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ParadoxEntity entity = this.findEntityByUUID(this.level, this.paradox_uuid);
        if (entity == null || entity.getShrinkScale() < 1.0f || !entity.isBlockWithinRadius(this.sourcePos) || this.dying) {
            if (!this.dying) {
                this.gravity = 0.04f;
                this.hasPhysics = true;
                this.lifetime = this.age + 20 + random.nextInt(41);
                this.dying = true;
            }
            this.deathMovement();
            return;
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            double dx = this.x - this.targetX;
            double dy = this.y - this.targetY;
            double dz = this.z - this.targetZ;
            double distanceToCenter = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double stopThreshold = 0.01;
            double minDistance = 0.005;
            double fixedTransitionDistance = 2.0;
            if (distanceToCenter > stopThreshold) {
                double baseGravitationalPull = distanceToCenter > fixedTransitionDistance ? 30.0 * distanceToCenter : 12.0;
                double proximityFactor = 1.0 / (distanceToCenter + 2.5);
                double adjustedGravitationalPull = this.gravitationalPull * proximityFactor * baseGravitationalPull;
                this.currentRadius -= adjustedGravitationalPull * 0.04;
                if (this.currentRadius < minDistance) {
                    this.currentRadius = minDistance;
                }
                this.angularVelocity += adjustedGravitationalPull * 4.0E-4;
                double maxAngularVelocity = 0.04;
                if (this.angularVelocity > maxAngularVelocity) {
                    this.angularVelocity = maxAngularVelocity;
                }
                this.currentAngle += this.angularVelocity;
                double directionX = dx / distanceToCenter;
                double directionY = dy / distanceToCenter;
                double directionZ = dz / distanceToCenter;
                this.x = this.targetX + this.currentRadius * (Math.cos(this.currentAngle) * directionX - Math.sin(this.currentAngle) * directionZ);
                this.z = this.targetZ + this.currentRadius * (Math.sin(this.currentAngle) * directionX + Math.cos(this.currentAngle) * directionZ);
                this.y = this.targetY + this.currentRadius * directionY * 0.975;
                this.setPos(this.x, this.y, this.z);
            } else {
                this.remove();
            }
        }
    }
}

