/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.renderers;

import com.direwolf20.justdirethings.common.entities.CreatureCatcherEntity;
import com.direwolf20.justdirethings.common.items.CreatureCatcher;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class JustDireItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ModelResourceLocation CREATURE_CATCHER_BASE = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"item/creaturecatcher_base"));

    public JustDireItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack pStack, ItemDisplayContext pDisplayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        if (pStack.getItem() instanceof CreatureCatcher) {
            ItemRenderer irenderer = Minecraft.getInstance().getItemRenderer();
            BakedModel base = irenderer.getItemModelShaper().getModelManager().getModel(CREATURE_CATCHER_BASE);
            pPoseStack.pushPose();
            if (pDisplayContext != ItemDisplayContext.GUI) {
                if (pDisplayContext == ItemDisplayContext.FIXED) {
                    pPoseStack.translate(0.0, 0.0, 0.5);
                    scale = 1.0f;
                    pPoseStack.scale(scale, scale, scale);
                    pPoseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                } else {
                    pPoseStack.translate(0.2, 0.5, 0.5);
                    scale = 0.4f;
                    pPoseStack.scale(scale, scale, scale);
                    pPoseStack.translate(0.0f, 0.0f, 0.0f);
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
                }
            } else {
                pPoseStack.translate(0.95f, 0.25f, 0.0f);
                pPoseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
                pPoseStack.mulPose(Axis.YP.rotationDegrees(225.0f));
                scale = 0.625f;
                pPoseStack.scale(scale, scale, scale);
                pPoseStack.translate(0.0f, 0.0f, 0.0f);
            }
            for (BakedModel model : base.getRenderPasses(pStack, true)) {
                for (RenderType rendertype : model.getRenderTypes(pStack, true)) {
                    VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)pBuffer, (RenderType)rendertype, (boolean)true, (boolean)pStack.hasFoil());
                    irenderer.renderModelLists(base, pStack, pPackedLight, pPackedOverlay, pPoseStack, vertexconsumer);
                }
            }
            pPoseStack.popPose();
            Mob mob = CreatureCatcherEntity.getEntityFromItemStack(pStack, (Level)Minecraft.getInstance().level);
            if (mob != null) {
                this.renderEntityInInventory(pPoseStack, pDisplayContext, (LivingEntity)mob, pBuffer);
            }
        }
    }

    public void renderEntityInInventory(PoseStack matrix, ItemDisplayContext type, LivingEntity pLivingEntity, MultiBufferSource pBuffer) {
        matrix.pushPose();
        matrix.translate(0.5, 0.5, 0.5);
        AABB boundingBox = pLivingEntity.getBoundingBox();
        double entityHeight = boundingBox.maxY - boundingBox.minY;
        double entityWidth = Math.max(boundingBox.maxX - boundingBox.minX, boundingBox.maxZ - boundingBox.minZ);
        double maxDimension = Math.max(entityWidth, entityHeight);
        float scale = 0.25f / (float)maxDimension;
        if (type == ItemDisplayContext.FIXED) {
            matrix.translate(0.0, 0.0, -0.125);
            matrix.mulPose(Axis.XN.rotationDegrees(90.0f));
            matrix.mulPose(Axis.YN.rotationDegrees(180.0f));
            matrix.scale(scale * 2.0f, scale * 2.0f, scale * 2.0f);
        } else if (type == ItemDisplayContext.GUI) {
            matrix.translate(0.0, -entityHeight / 2.0 * (double)scale * 2.0, 0.0);
            matrix.scale(scale * 2.0f, scale * 2.0f, scale * 2.0f);
        } else {
            matrix.translate(0.0, 0.02, 0.0);
            matrix.scale(scale, scale, scale);
        }
        float rotation = -30.0f;
        if (type == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || type == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            rotation = 30.0f;
        }
        if (type == ItemDisplayContext.FIXED) {
            rotation = 180.0f;
        }
        matrix.mulPose(Axis.YP.rotationDegrees(rotation));
        pLivingEntity.setYRot(0.0f);
        pLivingEntity.yBodyRot = pLivingEntity.getYRot();
        pLivingEntity.yHeadRot = pLivingEntity.getYRot();
        pLivingEntity.yHeadRotO = pLivingEntity.getYRot();
        EntityRenderDispatcher entityrenderermanager = Minecraft.getInstance().getEntityRenderDispatcher();
        entityrenderermanager.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> entityrenderermanager.render((Entity)pLivingEntity, 0.0, 0.0, 0.0, 0.0f, (float)Minecraft.getInstance().getFrameTimeNs(), matrix, pBuffer, 0xF000F0));
        entityrenderermanager.setRenderShadow(true);
        matrix.popPose();
    }
}

