/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.client.screens.basescreens.BaseMachineScreen;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.widgets.ToggleButton;
import com.direwolf20.justdirethings.common.blockentities.GeneratorT1BE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blocks.resources.CoalBlock_T1;
import com.direwolf20.justdirethings.common.containers.GeneratorT1Container;
import com.direwolf20.justdirethings.common.items.FuelCanister;
import com.direwolf20.justdirethings.common.items.resources.Coal_T1;
import com.direwolf20.justdirethings.util.MagicHelpers;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.MiscTools;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;

public class GeneratorT1Screen
extends BaseMachineScreen<GeneratorT1Container> {
    protected GeneratorT1Container container;
    protected GeneratorT1BE generatorBE;

    public GeneratorT1Screen(GeneratorT1Container container, Inventory inv, Component name) {
        super(container, inv, name);
        this.container = container;
        BaseMachineBE baseMachineBE = container.baseMachineBE;
        if (baseMachineBE instanceof GeneratorT1BE) {
            GeneratorT1BE generatorT1BE;
            this.generatorBE = generatorT1BE = (GeneratorT1BE)baseMachineBE;
        }
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void setTopSection() {
        this.extraWidth = 0;
        this.extraHeight = 0;
    }

    @Override
    public void addTickSpeedButton() {
    }

    @Override
    public void addRedstoneButtons() {
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.REDSTONEBUTTON(this.getGuiLeft() + 104, this.topSectionTop + 38, this.redstoneMode.ordinal(), b -> {
            this.redstoneMode = MiscHelpers.RedstoneMode.values()[((ToggleButton)b).getTexturePosition()];
            this.saveSettings();
        }));
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.blit(this.JUSTSLOT, this.getGuiLeft() + 79, this.getGuiTop() + 30, 0, 18, 18, 18);
        int maxBurn = this.container.getMaxBurn();
        int burnRemaining = this.container.getBurnRemaining();
        int maxHeight = 18;
        if (maxBurn > 0) {
            int remaining = burnRemaining * maxHeight / maxBurn;
            guiGraphics.blit(this.JUSTSLOT, this.getGuiLeft() + 79, this.getGuiTop() + 30 + 18 - remaining, 18, 36 - remaining, 18, remaining + 3);
        }
    }

    @Override
    public void powerBarTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof PoweredMachineBE) {
            PoweredMachineBE poweredMachineBE = (PoweredMachineBE)((Object)baseMachineBE);
            if (MiscTools.inBounds(this.topSectionLeft + 5, this.topSectionTop + 5, 18, 72, pX, pY)) {
                int burnRemaining = this.container.getBurnRemaining();
                if (GeneratorT1Screen.hasShiftDown()) {
                    pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.energy", (Object[])new Object[]{MagicHelpers.formatted(this.container.getEnergy()), MagicHelpers.formatted(poweredMachineBE.getMaxEnergy())}), burnRemaining > 0 ? Component.translatable((String)"justdirethings.screen.fepertick", (Object[])new Object[]{MagicHelpers.formatted(this.generatorBE.fePerTick())}) : Component.translatable((String)"justdirethings.screen.fepertick", (Object[])new Object[]{MagicHelpers.formatted(0)}), burnRemaining <= 0 ? Component.translatable((String)"justdirethings.screen.no_fuel") : Component.translatable((String)"justdirethings.screen.burn_time", (Object[])new Object[]{MagicHelpers.ticksInSeconds(burnRemaining)}))), pX, pY);
                } else {
                    pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.energy", (Object[])new Object[]{MagicHelpers.withSuffix(this.container.getEnergy()), MagicHelpers.withSuffix(poweredMachineBE.getMaxEnergy())}), burnRemaining > 0 ? Component.translatable((String)"justdirethings.screen.fepertick", (Object[])new Object[]{MagicHelpers.formatted(this.generatorBE.fePerTick())}) : Component.translatable((String)"justdirethings.screen.fepertick", (Object[])new Object[]{MagicHelpers.formatted(0)}), burnRemaining <= 0 ? Component.translatable((String)"justdirethings.screen.no_fuel") : Component.translatable((String)"justdirethings.screen.burn_time", (Object[])new Object[]{MagicHelpers.ticksInSeconds(burnRemaining)}))), pX, pY);
                }
            }
        }
    }

    @Override
    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        ItemStack fuelStack;
        int burnTime;
        if (((GeneratorT1Container)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem() && (burnTime = (fuelStack = this.hoveredSlot.getItem()).getBurnTime(RecipeType.SMELTING)) > 0) {
            int fuelBurnMultiplier = 1;
            Item item = fuelStack.getItem();
            if (item instanceof Coal_T1) {
                Coal_T1 direCoal = (Coal_T1)item;
                fuelBurnMultiplier = direCoal.getBurnSpeedMultiplier();
            } else {
                BlockItem blockItem;
                item = fuelStack.getItem();
                if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof CoalBlock_T1) {
                    CoalBlock_T1 coalBlock = (CoalBlock_T1)item;
                    fuelBurnMultiplier = coalBlock.getBurnSpeedMultiplier();
                } else if (fuelStack.getItem() instanceof FuelCanister) {
                    fuelBurnMultiplier = FuelCanister.getBurnSpeedMultiplier(fuelStack);
                }
            }
            List tooltip = this.getTooltipFromContainerItem(fuelStack);
            tooltip.add(Component.translatable((String)"justdirethings.screen.burnspeedmultiplier", (Object[])new Object[]{fuelBurnMultiplier}).withStyle(ChatFormatting.RED));
            pGuiGraphics.renderTooltip(this.font, tooltip, fuelStack.getTooltipImage(), fuelStack, pX, pY);
            return;
        }
        super.renderTooltip(pGuiGraphics, pX, pY);
    }
}

