/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.capabilities.InventoryHolderItemHandler;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.ItemStackKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class InventoryHolderBE
extends BaseMachineBE {
    public FilterBasicHandler filterBasicHandler = new FilterBasicHandler(41);
    public Map<ItemStackKey, List<Integer>> filteredCache = new HashMap<ItemStackKey, List<Integer>>();
    public boolean compareNBT = false;
    public boolean filtersOnly = false;
    public boolean automatedFiltersOnly = false;
    public boolean compareCounts = false;
    public boolean automatedCompareCounts = false;
    public int renderedSlot = 27;
    public boolean renderPlayer = true;

    public InventoryHolderBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.MACHINE_SLOTS = 41;
    }

    public InventoryHolderBE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.InventoryHolderBE.get(), pPos, pBlockState);
    }

    public void addSavedItem(int slot) {
        ItemStack itemStack = this.getMachineHandler().getStackInSlot(slot).copy();
        this.filterBasicHandler.setStackInSlot(slot, itemStack);
        this.rebuildFilterCache();
        this.markDirtyClient();
    }

    public void saveSettings(boolean compareNBT, boolean filtersOnly, boolean compareCounts, boolean automatedFiltersOnly, boolean automatedCompareCounts, boolean renderPlayer, int renderedSlot) {
        this.compareNBT = compareNBT;
        this.filtersOnly = filtersOnly;
        this.compareCounts = compareCounts;
        this.automatedFiltersOnly = automatedFiltersOnly;
        this.automatedCompareCounts = automatedCompareCounts;
        this.renderPlayer = renderPlayer;
        this.renderedSlot = renderedSlot;
        this.markDirtyClient();
    }

    public void rebuildFilterCache() {
        this.filteredCache.clear();
        for (int i = 0; i < this.filterBasicHandler.getSlots(); ++i) {
            ItemStack stack = this.filterBasicHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ItemStackKey key = new ItemStackKey(stack, this.compareNBT);
            List slotList = this.filteredCache.getOrDefault(key, new ArrayList());
            slotList.add(i);
            this.filteredCache.put(key, slotList);
        }
    }

    public ItemStackHandler getInventoryHolderHandler() {
        return new InventoryHolderItemHandler(this, this.getMachineHandler());
    }

    public int allowedExtractAmount(int slot, int amount) {
        ItemStack stack = this.filterBasicHandler.getStackInSlot(slot);
        if (stack.isEmpty()) {
            return amount;
        }
        if (this.automatedCompareCounts) {
            int amountHad;
            int amountDesired = this.getSlotLimit(slot);
            if (amountDesired > (amountHad = this.getMachineHandler().getStackInSlot(slot).getCount())) {
                return 0;
            }
            return Math.min(amount, amountHad - amountDesired);
        }
        return 0;
    }

    public boolean isStackValidFilter(ItemStack testStack, int slot) {
        ItemStackKey key = new ItemStackKey(testStack, this.compareNBT);
        ItemStack stack = this.filterBasicHandler.getStackInSlot(slot);
        if (stack.isEmpty()) {
            return !this.automatedFiltersOnly;
        }
        return key.equals(new ItemStackKey(stack, this.compareNBT));
    }

    public int getSlotLimit(int slot) {
        if (!this.automatedCompareCounts) {
            return -1;
        }
        ItemStack stack = this.filterBasicHandler.getStackInSlot(slot);
        if (stack.isEmpty()) {
            return -1;
        }
        return stack.getCount();
    }

    @Override
    public boolean isDefaultSettings() {
        if (this.compareNBT) {
            return false;
        }
        if (this.filtersOnly) {
            return false;
        }
        if (this.automatedFiltersOnly) {
            return false;
        }
        if (this.compareCounts) {
            return false;
        }
        if (this.automatedCompareCounts) {
            return false;
        }
        if (this.renderedSlot != 27) {
            return false;
        }
        for (int i = 0; i < this.filterBasicHandler.getSlots(); ++i) {
            if (this.filterBasicHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        ItemStackHandler itemStackHandler = this.getMachineHandler();
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            if (itemStackHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void saveInventory(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("storedItems", (Tag)this.getMachineHandler().serializeNBT(provider));
    }

    public void loadInventory(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("storedItems")) {
            CompoundTag filteredItems = tag.getCompound("storedItems");
            this.getMachineHandler().deserializeNBT(provider, filteredItems);
            this.rebuildFilterCache();
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("compareNBT", this.compareNBT);
        tag.putBoolean("filtersOnly", this.filtersOnly);
        tag.putBoolean("compareCounts", this.compareCounts);
        tag.putBoolean("automatedFiltersOnly", this.automatedFiltersOnly);
        tag.putBoolean("automatedCompareCounts", this.automatedCompareCounts);
        tag.putBoolean("renderPlayer", this.renderPlayer);
        tag.putInt("renderedSlot", this.renderedSlot);
        tag.put("filteredItems", (Tag)this.filterBasicHandler.serializeNBT(provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.compareNBT = tag.getBoolean("compareNBT");
        this.filtersOnly = tag.getBoolean("filtersOnly");
        this.compareCounts = tag.getBoolean("compareCounts");
        this.automatedFiltersOnly = tag.getBoolean("automatedFiltersOnly");
        this.automatedCompareCounts = tag.getBoolean("automatedCompareCounts");
        if (tag.contains("renderPlayer")) {
            this.renderPlayer = tag.getBoolean("renderPlayer");
        }
        if (tag.contains("renderedSlot")) {
            this.renderedSlot = tag.getInt("renderedSlot");
        }
        if (tag.contains("filteredItems")) {
            CompoundTag filteredItems = tag.getCompound("filteredItems");
            this.filterBasicHandler.deserializeNBT(provider, filteredItems);
            this.rebuildFilterCache();
        }
    }
}

