/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blocks;

import com.direwolf20.justdirethings.common.blockentities.InventoryHolderBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blocks.baseblocks.BaseMachineBlock;
import com.direwolf20.justdirethings.common.containers.InventoryHolderContainer;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class InventoryHolder
extends BaseMachineBlock {
    public InventoryHolder() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(2.0f).isRedstoneConductor(BaseMachineBlock::never));
    }

    @javax.annotation.Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new InventoryHolderBE(pos, state);
    }

    @Override
    public void openMenu(Player player, BlockPos blockPos) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new InventoryHolderContainer(windowId, playerInventory, blockPos), (Component)Component.translatable((String)"")), buf -> buf.writeBlockPos(blockPos));
    }

    @Override
    public boolean isValidBE(BlockEntity blockEntity) {
        return blockEntity instanceof InventoryHolderBE;
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && !state.is(newState.getBlock())) {
            level.removeBlockEntity(pos);
        }
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        if (!world.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof InventoryHolderBE) {
                CompoundTag compound;
                InventoryHolderBE inventoryHolderBE = (InventoryHolderBE)blockEntity;
                if (stack.has(JustDireDataComponents.CUSTOM_DATA_1) && !(compound = ((CustomData)stack.get(JustDireDataComponents.CUSTOM_DATA_1)).copyTag()).isEmpty()) {
                    inventoryHolderBE.loadInventory(compound, (HolderLookup.Provider)world.registryAccess());
                }
            }
        }
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BaseMachineBE baseMachineBE;
        List<ItemStack> drops = super.getDrops(state, builder);
        BlockEntity blockEntity = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof BaseMachineBE && !(baseMachineBE = (BaseMachineBE)blockEntity).isDefaultSettings()) {
            ItemStack itemStack = new ItemStack((ItemLike)Item.byBlock((Block)this));
            CompoundTag compoundTag = new CompoundTag();
            ((BaseMachineBE)blockEntity).saveAdditional(compoundTag, (HolderLookup.Provider)builder.getLevel().registryAccess());
            ((InventoryHolderBE)blockEntity).saveInventory(compoundTag, (HolderLookup.Provider)builder.getLevel().registryAccess());
            if (!compoundTag.isEmpty()) {
                itemStack.set(JustDireDataComponents.CUSTOM_DATA_1, (Object)CustomData.of((CompoundTag)compoundTag));
            }
            drops.clear();
            drops.add(itemStack);
        }
        return drops;
    }

    @Override
    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return null;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        return state;
    }

    @Override
    public BlockState direRotate(BlockState blockState, LevelAccessor level, BlockPos pos, Rotation direction) {
        return blockState;
    }
}

