/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.containers.slots;

import com.direwolf20.justdirethings.common.blockentities.InventoryHolderBE;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.util.ItemStackKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class InventoryHolderSlot
extends SlotItemHandler {
    private InventoryHolderBE inventoryHolderBE;

    public InventoryHolderSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, InventoryHolderBE inventoryHolderBE) {
        super(itemHandler, index, xPosition, yPosition);
        this.inventoryHolderBE = inventoryHolderBE;
    }

    public boolean mayPlace(ItemStack stack) {
        return this.mayPlaceFiltered(stack);
    }

    public int getMaxStackSize() {
        if (this.inventoryHolderBE.compareCounts) {
            return this.getFilterStackSize();
        }
        return super.getMaxStackSize();
    }

    public int getMaxStackSize(ItemStack stack) {
        if (this.inventoryHolderBE.compareCounts) {
            return this.getFilterStackSize(stack);
        }
        return super.getMaxStackSize(stack);
    }

    public boolean mayPlaceFiltered(ItemStack currentStack) {
        if (this.inventoryHolderBE == null) {
            return false;
        }
        ItemStackKey key = new ItemStackKey(currentStack, this.inventoryHolderBE.compareNBT);
        FilterBasicHandler filteredItems = this.inventoryHolderBE.filterBasicHandler;
        ItemStack stack = filteredItems.getStackInSlot(this.index);
        if (stack.isEmpty()) {
            return !this.inventoryHolderBE.filtersOnly;
        }
        return key.equals(new ItemStackKey(stack, this.inventoryHolderBE.compareNBT));
    }

    public int getFilterStackSize() {
        if (this.inventoryHolderBE == null) {
            return 0;
        }
        FilterBasicHandler filteredItems = this.inventoryHolderBE.filterBasicHandler;
        ItemStack filterStack = filteredItems.getStackInSlot(this.index);
        if (filterStack.isEmpty()) {
            return super.getMaxStackSize();
        }
        return filterStack.getCount();
    }

    public int getFilterStackSize(ItemStack stack) {
        if (this.inventoryHolderBE == null) {
            return 0;
        }
        FilterBasicHandler filteredItems = this.inventoryHolderBE.filterBasicHandler;
        ItemStack filterStack = filteredItems.getStackInSlot(this.index);
        if (filterStack.isEmpty()) {
            return super.getMaxStackSize(stack);
        }
        return filterStack.getCount();
    }
}

