/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.Tooltips;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.api.ThresholdMode;
import com.glodblock.github.extendedae.client.button.CycleEPPButton;
import com.glodblock.github.extendedae.client.button.EPPIcon;
import com.glodblock.github.extendedae.client.gui.subgui.SetAmount;
import com.glodblock.github.extendedae.client.hotkey.EAEHotKey;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.parts.PartThresholdExportBus;
import com.glodblock.github.extendedae.container.ContainerThresholdExportBus;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CEAEGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class GuiThresholdExportBus
extends UpgradeableScreen<ContainerThresholdExportBus>
implements IActionHolder {
    private final SettingToggleButton<RedstoneMode> redstoneMode;
    private final SettingToggleButton<SchedulingMode> schedulingMode;
    private final CycleEPPButton thresholdMode;
    private final ActionMap actions = ActionMap.create();

    public GuiThresholdExportBus(ContainerThresholdExportBus menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.redstoneMode = new ServerSettingToggleButton(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.addToLeftToolbar((Button)this.redstoneMode);
        if (((PartThresholdExportBus)menu.getHost()).getConfigManager().hasSetting(Settings.SCHEDULING_MODE)) {
            this.schedulingMode = new ServerSettingToggleButton(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
            this.addToLeftToolbar((Button)this.schedulingMode);
        } else {
            this.schedulingMode = null;
        }
        this.thresholdMode = new CycleEPPButton();
        this.thresholdMode.addActionPair(EPPIcon.OVER_STACK, (Component)Component.translatable((String)"gui.extendedae.threshold_export_bus.greater"), b -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set", ThresholdMode.LOWER.ordinal())));
        this.thresholdMode.addActionPair(EPPIcon.BELOW_STACK, (Component)Component.translatable((String)"gui.extendedae.threshold_export_bus.lower"), b -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set", ThresholdMode.GREATER.ordinal())));
        this.actions.put("init", o -> this.thresholdMode.setState((Integer)o.get(0)));
        EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("update"));
        this.addToLeftToolbar((Button)this.thresholdMode);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.redstoneMode.set((Enum)((ContainerThresholdExportBus)this.menu).getRedStoneMode());
        this.redstoneMode.setVisibility(((ContainerThresholdExportBus)this.menu).hasUpgrade((ItemLike)AEItems.REDSTONE_CARD));
        if (this.schedulingMode != null) {
            this.schedulingMode.set((Enum)((ContainerThresholdExportBus)this.menu).getSchedulingMode());
        }
        this.thresholdMode.setState(((ContainerThresholdExportBus)this.menu).getMode().ordinal());
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        GenericStack currentStack;
        Slot slot;
        assert (this.minecraft != null);
        if (EAEHotKey.SET_AMOUNT.matchesMouse(btn) && this.isValidSlot(slot = this.findSlot(xCoord, yCoord)) && (currentStack = GenericStack.fromItemStack((ItemStack)slot.getItem())) != null) {
            SetAmount screen = new SetAmount(this, new ItemStack(EAESingletons.THRESHOLD_EXPORT_BUS), currentStack, newStack -> PacketDistributor.sendToServer((CustomPacketPayload)new InventoryActionPacket(InventoryAction.SET_FILTER, slot.index, GenericStack.wrapInItemStack((GenericStack)newStack)), (CustomPacketPayload[])new CustomPacketPayload[0]), false);
            this.switchToScreen((AEBaseScreen)screen);
            return true;
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        if (((ContainerThresholdExportBus)this.menu).getCarried().isEmpty() && this.isValidSlot(this.hoveredSlot)) {
            ArrayList<Component> itemTooltip = new ArrayList<Component>(this.getTooltipFromContainerItem(this.hoveredSlot.getItem()));
            GenericStack unwrapped = GenericStack.fromItemStack((ItemStack)this.hoveredSlot.getItem());
            if (unwrapped != null) {
                itemTooltip.add(Tooltips.getAmountTooltip((ButtonToolTips)ButtonToolTips.Amount, (GenericStack)unwrapped));
            }
            itemTooltip.add(Tooltips.getSetAmountTooltip());
            this.drawTooltip(guiGraphics, x, y, itemTooltip);
        } else {
            super.renderTooltip(guiGraphics, x, y);
        }
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(guiGraphics, offsetX, offsetY, mouseX, mouseY);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(10.0f, 17.0f, 0.0f);
        poseStack.scale(0.6f, 0.6f, 1.0f);
        Color color = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.extendedae.precise_export_bus.set_amount"), 0, 0, color.toARGB(), false);
        poseStack.popPose();
    }

    private boolean isValidSlot(Slot slot) {
        return slot != null && slot.isActive() && slot.hasItem() && ((ContainerThresholdExportBus)this.menu).isConfigSlot(slot);
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }
}

