/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.core.AppEng;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.client.button.ActionEPPButton;
import com.glodblock.github.extendedae.client.button.HighlightButton;
import com.glodblock.github.extendedae.common.me.wireless.WirelessStatus;
import com.glodblock.github.extendedae.container.ContainerWirelessHub;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CEAEGenericPacket;
import com.glodblock.github.extendedae.util.MessageUtil;
import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiWirelessHub
extends UpgradeableScreen<ContainerWirelessHub> {
    private static final Blitter PORT = Blitter.texture((ResourceLocation)AppEng.makeId((String)"textures/guis/wireless_hub.png")).src(176, 0, 16, 16);
    private static final int COL1_X = 37;
    private static final int COL2_X = 120;
    private static final int COL_Y = 44;
    private static final int Y_OFFSET = 28;
    private static final int PADDING_X = 8;
    private static final int PADDING_Y = 6;
    private final RemoteBlock[] remotes = new RemoteBlock[8];
    private final HighlightButton[] highlightBtn = new HighlightButton[8];
    private final ActionEPPButton[] disconnectBtn = new ActionEPPButton[8];

    public GuiWirelessHub(ContainerWirelessHub menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        for (int i = 0; i < 8; ++i) {
            int port = i;
            this.remotes[i] = new RemoteBlock(() -> menu.getRemotePosition(port), 0, 0, 16, 16);
            this.highlightBtn[i] = new HighlightButton();
            this.highlightBtn[i].setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.wireless_connect.highlight.tooltip")));
            this.disconnectBtn[i] = new ActionEPPButton(b -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("disconnect", port)), Icon.CLEAR);
            this.disconnectBtn[i].setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.wireless_hub.disconnect.tooltip")));
        }
    }

    public void init() {
        super.init();
        for (int i = 0; i < 8; ++i) {
            int X = i < 4 ? 37 : 120;
            int Y = i % 4;
            this.remotes[i].setPosition(this.leftPos + X, this.topPos + 44 + Y * 28);
            this.highlightBtn[i].setPosition(this.leftPos + X - 18, this.topPos + 44 + Y * 28 - 2);
            this.disconnectBtn[i].setPosition(this.leftPos + X + 18, this.topPos + 44 + Y * 28 - 2);
            this.addRenderableOnly((Renderable)this.remotes[i]);
            this.addRenderableWidget((GuiEventListener)this.highlightBtn[i]);
            this.addRenderableWidget((GuiEventListener)this.disconnectBtn[i]);
        }
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        ResourceKey dim = this.getPlayer().clientLevel.dimension();
        for (int i = 0; i < 8; ++i) {
            WirelessStatus status = ((ContainerWirelessHub)this.menu).getStatus(i);
            if (status == WirelessStatus.WORKING || status == WirelessStatus.NO_POWER) {
                BlockPos remotePos = ((ContainerWirelessHub)this.menu).getRemotePosition(i);
                this.highlightBtn[i].active = true;
                this.highlightBtn[i].setTarget(remotePos, (ResourceKey<Level>)dim);
                this.highlightBtn[i].setMultiplier(this.playerToBlockDis(remotePos));
                this.highlightBtn[i].setSuccessJob(() -> {
                    if (this.getPlayer() != null) {
                        Component message = MessageUtil.createEnhancedHighlightMessage((Player)this.getPlayer(), remotePos, (ResourceKey<Level>)this.getPlayer().clientLevel.dimension(), "chat.wireless.highlight");
                        this.getPlayer().displayClientMessage(message, false);
                    }
                });
                this.remotes[i].setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.wireless_connect.remote", (Object[])new Object[]{remotePos.getX(), remotePos.getY(), remotePos.getZ()})));
                this.remotes[i].setConnected(true);
                continue;
            }
            this.highlightBtn[i].active = false;
            this.remotes[i].setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.wireless_hub.empty_port.tooltip")));
            this.remotes[i].setConnected(false);
        }
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int len = 12;
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.wireless_connect.power", (Object[])new Object[]{String.format("%.2f", ((ContainerWirelessHub)this.menu).powerUse)}), 8, 6 + len, textColor, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.wireless_connect.channel", (Object[])new Object[]{((ContainerWirelessHub)this.menu).usedChannel, ((ContainerWirelessHub)this.menu).maxChannel}), 8, 6 + len * 2, textColor, false);
    }

    private double playerToBlockDis(BlockPos pos) {
        if (pos == null) {
            return 0.0;
        }
        BlockPos ps = this.getPlayer().getOnPos();
        return pos.distSqr((Vec3i)ps);
    }

    private static class RemoteBlock
    extends AbstractWidget {
        private final Supplier<BlockPos> locator;
        @Nullable
        private BlockPos localPos;
        private ItemStack localBlock = ItemStack.EMPTY;
        private boolean isConnected = false;

        public RemoteBlock(Supplier<BlockPos> locator, int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.empty());
            this.locator = locator;
        }

        private void setConnected(boolean connected) {
            this.isConnected = connected;
        }

        protected void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            if (this.localPos != this.locator.get() && Minecraft.getInstance().level != null) {
                this.localPos = this.locator.get();
                this.localBlock = new ItemStack((ItemLike)Minecraft.getInstance().level.getBlockState(this.localPos).getBlock());
            }
            if (this.isConnected) {
                graphics.renderItem(this.localBlock, this.getX(), this.getY(), 0, 3);
            } else {
                PORT.dest(this.getX(), this.getY()).blit(graphics);
            }
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

