/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.blocks;

import appeng.block.AEBaseBlock;
import appeng.core.definitions.AEBlocks;
import com.glodblock.github.extendedae.api.ISpecialDrop;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.blocks.BlockEntroCluster;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockBuddingEntro
extends AEBaseBlock
implements ISpecialDrop {
    public static final int GROWTH_CHANCE = 3;
    public static final int DECAY_CHANCE = 10;
    private static final Direction[] DIRECTIONS = Direction.values();

    public BlockBuddingEntro() {
        super(BlockBuddingEntro.stoneProps().strength(3.0f, 8.0f).requiresCorrectToolForDrops().randomTicks());
    }

    public PushReaction getPistonPushReaction(@NotNull BlockState state) {
        return PushReaction.DESTROY;
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, RandomSource randomSource) {
        if (randomSource.nextInt(3) != 0) {
            return;
        }
        Direction direction = (Direction)Util.getRandom((Object[])DIRECTIONS, (RandomSource)randomSource);
        BlockPos targetPos = pos.relative(direction);
        BlockState targetState = level.getBlockState(targetPos);
        BlockEntroCluster newCluster = BlockBuddingEntro.canClusterGrowAtState(targetState) ? EAESingletons.ENTRO_BUD_SMALL : BlockBuddingEntro.canClusterGrow(targetState, direction);
        if (newCluster == null) {
            return;
        }
        BlockState newClusterState = (BlockState)((BlockState)newCluster.defaultBlockState().setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction)).setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(targetState.getFluidState().getType() == Fluids.WATER));
        level.setBlockAndUpdate(targetPos, newClusterState);
        if (randomSource.nextInt(10) != 0) {
            return;
        }
        Block newBlock = this.degradeBudding();
        level.setBlockAndUpdate(pos, newBlock.defaultBlockState());
    }

    public static boolean canClusterGrowAtState(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER) && state.getFluidState().getAmount() == 8;
    }

    @Nullable
    public static Block canClusterGrow(BlockState state, Direction side) {
        Block cluster = state.getBlock();
        if (cluster instanceof BlockEntroCluster && cluster != EAESingletons.ENTRO_CLUSTER && state.getValue((Property)AmethystClusterBlock.FACING) == side) {
            if (cluster == EAESingletons.ENTRO_BUD_SMALL) {
                return EAESingletons.ENTRO_BUD_MEDIUM;
            }
            if (cluster == EAESingletons.ENTRO_BUD_MEDIUM) {
                return EAESingletons.ENTRO_BUD_LARGE;
            }
            if (cluster == EAESingletons.ENTRO_BUD_LARGE) {
                return EAESingletons.ENTRO_CLUSTER;
            }
        }
        return null;
    }

    public Block degradeBudding() {
        if (this == EAESingletons.FULLY_ENTROIZED_FLUIX_BUDDING) {
            return EAESingletons.MOSTLY_ENTROIZED_FLUIX_BUDDING;
        }
        if (this == EAESingletons.MOSTLY_ENTROIZED_FLUIX_BUDDING) {
            return EAESingletons.HALF_ENTROIZED_FLUIX_BUDDING;
        }
        if (this == EAESingletons.HALF_ENTROIZED_FLUIX_BUDDING) {
            return EAESingletons.HARDLY_ENTROIZED_FLUIX_BUDDING;
        }
        return AEBlocks.QUARTZ_BLOCK.block();
    }
}

