/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.blocks;

import appeng.block.crafting.PatternProviderBlock;
import appeng.block.crafting.PushDirection;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.glodblock.github.extendedae.common.blocks.BlockBaseGui;
import com.glodblock.github.extendedae.common.tileentities.TileExPatternProvider;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BlockExPatternProvider
extends BlockBaseGui<TileExPatternProvider> {
    public BlockExPatternProvider() {
        super(BlockExPatternProvider.metalProps());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PatternProviderBlock.PUSH_DIRECTION, (Comparable)PushDirection.ALL));
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PatternProviderBlock.PUSH_DIRECTION});
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        TileExPatternProvider be = (TileExPatternProvider)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            be.getLogic().updateRedstoneState();
        }
    }

    @Override
    public ItemInteractionResult check(TileExPatternProvider tile, ItemStack stack, Level world, BlockPos pos, BlockHitResult hit, Player p) {
        if (stack != null && InteractionUtil.canWrenchRotate((ItemStack)stack)) {
            this.setSide(world, pos, hit.getDirection());
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return null;
    }

    @Override
    public void openGui(TileExPatternProvider tile, Player p) {
        tile.openMenu(p, MenuLocators.forBlockEntity((BlockEntity)tile));
    }

    public void setSide(Level level, BlockPos pos, Direction facing) {
        BlockState currentState = level.getBlockState(pos);
        Direction pushSide = ((PushDirection)currentState.getValue((Property)PatternProviderBlock.PUSH_DIRECTION)).getDirection();
        PushDirection newPushDirection = pushSide == facing.getOpposite() ? PushDirection.fromDirection((Direction)facing) : (pushSide == facing ? PushDirection.ALL : (pushSide == null ? PushDirection.fromDirection((Direction)facing.getOpposite()) : PushDirection.fromDirection((Direction)Platform.rotateAround((Direction)pushSide, (Direction)facing))));
        level.setBlockAndUpdate(pos, (BlockState)currentState.setValue((Property)PatternProviderBlock.PUSH_DIRECTION, (Comparable)newPushDirection));
    }
}

