/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.network.packet;

import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.client.gui.GuiAssemblerMatrix;
import com.glodblock.github.glodium.network.packet.IMessage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SAssemblerMatrixUpdate
implements IMessage {
    private long patternID;
    private Int2ObjectMap<ItemStack> updateMap;

    public SAssemblerMatrixUpdate() {
    }

    public SAssemblerMatrixUpdate(long id, Int2ObjectMap<ItemStack> updateMap) {
        this.patternID = id;
        this.updateMap = new Int2ObjectOpenHashMap(updateMap);
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeLong(this.patternID);
        buf.writeInt(this.updateMap.size());
        for (Int2ObjectMap.Entry entry : this.updateMap.int2ObjectEntrySet()) {
            buf.writeInt(entry.getIntKey());
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)((ItemStack)entry.getValue()));
        }
    }

    public void fromBytes(RegistryFriendlyByteBuf buf) {
        this.patternID = buf.readLong();
        this.updateMap = new Int2ObjectOpenHashMap();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.updateMap.put(buf.readInt(), (Object)((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf)));
        }
    }

    public boolean isClient() {
        return true;
    }

    public ResourceLocation id() {
        return ExtendedAE.id("assembler_matrix_update");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onMessage(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof GuiAssemblerMatrix) {
            GuiAssemblerMatrix gui = (GuiAssemblerMatrix)screen;
            gui.receiveUpdate(this.patternID, this.updateMap);
        }
    }
}

