/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.generatorgalore.common.block.entity.GeneratorBlockEntity;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;

public class Generator
extends BaseEntityBlock {
    public static final MapCodec<Generator> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Generator.propertiesCodec(), (App)GeneratorObject.codec(ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"generator_codec")).fieldOf("generator").forGetter(generator -> generator.generator), (App)Codec.INT.fieldOf("modifier").forGetter(generator -> generator.modifier)).apply((Applicative)builder, Generator::new));
    GeneratorObject generator;
    private final int modifier;

    public Generator(BlockBehaviour.Properties properties, GeneratorObject generator, int modifier) {
        super(properties);
        this.generator = generator;
        this.modifier = modifier;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{HorizontalDirectionalBlock.FACING, BlockStateProperties.LIT});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : Generator.createTickerHelper(blockEntityType, this.generator.getBlockEntityType().get(), GeneratorBlockEntity::tick);
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    @NotNull
    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)rotation.rotate((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new GeneratorBlockEntity(this.generator, pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (this.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID) && pStack.getCapability(Capabilities.FluidHandler.ITEM) != null && FluidUtil.interactWithFluidHandler((Player)pPlayer, (InteractionHand)pHand, (Level)pLevel, (BlockPos)pPos, null)) {
            pPlayer.swing(pHand);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)blockEntity;
            if (!pLevel.isClientSide) {
                generatorBlockEntity.refreshConnectedTileEntityCache();
                pPlayer.openMenu((MenuProvider)generatorBlockEntity, packetBuffer -> packetBuffer.writeBlockPos(pPos));
            }
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState newState, boolean something) {
        BlockEntity generatorTile = level.getBlockEntity(pos);
        if (generatorTile instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)generatorTile;
            generatorBlockEntity.refreshConnectedTileEntityCache();
        }
        super.onPlace(state, level, pos, newState, something);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        BlockEntity generatorTile = level.getBlockEntity(pos);
        if (generatorTile instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)generatorTile;
            generatorBlockEntity.refreshConnectedTileEntityCache();
        }
        return super.updateShape(state, direction, newState, level, pos, facingPos);
    }

    public void animateTick(BlockState pState, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)pState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            double d2;
            double d1;
            double d0;
            int i;
            if (random.nextInt(11) == 0) {
                block5: for (i = 0; i < random.nextInt(1) + 1; ++i) {
                    switch (this.generator.getFuelType()) {
                        case FLUID: {
                            continue block5;
                        }
                        case FOOD: {
                            d0 = (double)pos.getX() + 0.4 + (double)random.nextFloat() * 0.2;
                            d1 = (double)pos.getY() + 0.7 + (double)random.nextFloat() * 0.3;
                            d2 = (double)pos.getZ() + 0.4 + (double)random.nextFloat() * 0.2;
                            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                            continue block5;
                        }
                        case ENCHANTMENT: {
                            continue block5;
                        }
                        default: {
                            level.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
                        }
                    }
                }
            }
            if (random.nextInt(55) == 0) {
                for (i = 0; i < level.random.nextInt(2) + 2; ++i) {
                    d0 = (double)pos.getX() + 0.5;
                    d1 = pos.getY();
                    d2 = (double)pos.getZ() + 0.5;
                    if (random.nextDouble() < 0.1) {
                        level.playLocalSound(d0, d1, d2, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1 + 1.1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (oldState.getBlock() != newState.getBlock() && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)blockEntity;
            for (int slot = 0; slot < generatorBlockEntity.inventoryHandler.getSlots(); ++slot) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)generatorBlockEntity.inventoryHandler.getStackInSlot(slot));
            }
        }
        super.onRemove(oldState, level, pos, newState, isMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)pLevel.getBlockEntity(pPos));
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
        pTootipComponents.add((Component)Component.translatable((String)"generatorgalore.screen.generation_rate", (Object[])new Object[]{this.generator.getGenerationRate() * (double)this.modifier}).withStyle(ChatFormatting.BLUE));
        pTootipComponents.add((Component)Component.translatable((String)"generatorgalore.screen.transfer_rate", (Object[])new Object[]{this.generator.getTransferRate() * (double)this.modifier}).withStyle(ChatFormatting.BLUE));
        pTootipComponents.add((Component)Component.translatable((String)"generatorgalore.screen.max_energy", (Object[])new Object[]{this.generator.getBufferCapacity() * this.modifier}).withStyle(ChatFormatting.BLUE));
        pTootipComponents.add((Component)Component.translatable((String)"generatorgalore.screen.fuel_type", (Object[])new Object[]{this.generator.getFuelType().getSerializedName()}).withStyle(ChatFormatting.BLUE));
    }

    public int getModifier() {
        return this.modifier;
    }
}

