/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.blocks;

import com.thevortex.allthemodium.registry.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;

public class Unobtainium_Ore
extends DropExperienceBlock {
    private static final IntProvider xpRange = new IntProvider(){

        public int getMaxValue() {
            return 50;
        }

        public int getMinValue() {
            return 25;
        }

        public IntProviderType<?> getType() {
            return IntProviderType.CONSTANT;
        }

        public int sample(RandomSource arg0) {
            return arg0.nextIntBetweenInclusive(this.getMinValue(), this.getMaxValue());
        }
    };

    public Unobtainium_Ore() {
        super(xpRange, BlockBehaviour.Properties.of().requiresCorrectToolForDrops().sound(SoundType.NETHER_GOLD_ORE).strength(-1.0f, 5000.0f));
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity player) {
        if (player instanceof FakePlayer && state.getBlock() == ModRegistry.UNOBTAINIUM_ORE.get()) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, player) && this.distanceTo(pos, player.blockPosition()) < 16.0;
    }

    private double distanceTo(BlockPos block, BlockPos player) {
        return Math.sqrt(Math.pow(block.getX() - player.getX(), 2.0) + Math.pow(block.getY() - player.getY(), 2.0) + Math.pow(block.getZ() - player.getZ(), 2.0));
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter getter, BlockPos blockPos) {
        BlockEntity blockEntity = getter.getBlockEntity(blockPos);
        if (this.canEntityDestroy(state, getter, blockPos, (Entity)player)) {
            int i = player.hasCorrectToolForDrops(state, player.level(), blockPos) ? 250 : 1500;
            return player.getDigSpeed(state, blockPos) / 2.0f / (float)i;
        }
        return 0.0f;
    }
}

