/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.events;

import com.thevortex.allthemodium.entity.PiglichEntity;
import com.thevortex.allthemodium.registry.ModRegistry;
import java.util.Iterator;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="allthemodium")
public class ArmorEvents {
    @SubscribeEvent
    public static void onPlayerFall(LivingFallEvent event) {
        Iterable armorlist = event.getEntity().getArmorSlots();
        for (ItemStack armor : armorlist) {
            if (armor.getItem() != ModRegistry.ALLTHEMODIUM_BOOTS.get() && armor.getItem() != ModRegistry.VIBRANIUM_BOOTS.get() && armor.getItem() != ModRegistry.UNOBTAINIUM_BOOTS.get()) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent.Pre event) {
        if (event.getEntity() instanceof PiglichEntity) {
            // empty if block
        }
        if (!event.getEntity().getCommandSenderWorld().isClientSide) {
            ItemStack armor;
            Iterable armorlist = event.getEntity().getArmorSlots();
            Iterator iterator = armorlist.iterator();
            if (event.getSource().is(DamageTypes.MAGIC)) {
                while (iterator.hasNext()) {
                    ItemStack armor2 = (ItemStack)iterator.next();
                    if (armor2.getItem() == ModRegistry.ALLTHEMODIUM_CHESTPLATE.get()) {
                        event.setNewDamage(event.getNewDamage() * 0.5f);
                    }
                    if (armor2.getItem() == ModRegistry.VIBRANIUM_CHESTPLATE.get()) {
                        event.setNewDamage(event.getNewDamage() * 0.25f);
                    }
                    if (armor2.getItem() != ModRegistry.UNOBTAINIUM_CHESTPLATE.get()) continue;
                    event.setNewDamage(event.getNewDamage() * 0.1f);
                }
                return;
            }
            if (event.getSource().is(DamageTypes.FELL_OUT_OF_WORLD)) {
                while (iterator.hasNext()) {
                    armor = (ItemStack)iterator.next();
                    if (armor.getItem() != ModRegistry.UNOBTAINIUM_CHESTPLATE.get()) continue;
                    event.setNewDamage(0.0f);
                }
            }
            while (iterator.hasNext()) {
                armor = (ItemStack)iterator.next();
                if ((armor.getItem() == ModRegistry.ALLTHEMODIUM_CHESTPLATE.get() || armor.getItem() == ModRegistry.VIBRANIUM_CHESTPLATE.get() || armor.getItem() == ModRegistry.UNOBTAINIUM_CHESTPLATE.get()) && (event.getSource().is(DamageTypes.IN_FIRE) || event.getSource().is(DamageTypes.ON_FIRE) || event.getSource().is(DamageTypes.LAVA) || event.getSource().is(DamageTypes.HOT_FLOOR))) {
                    event.getEntity().clearFire();
                    event.setNewDamage(0.0f);
                }
                if (armor.getItem() != ModRegistry.ALLTHEMODIUM_HELMET.get() && armor.getItem() != ModRegistry.VIBRANIUM_HELMET.get() && armor.getItem() != ModRegistry.UNOBTAINIUM_HELMET.get()) continue;
                if (event.getSource().is(DamageTypes.FLY_INTO_WALL)) {
                    event.setNewDamage(0.0f);
                }
                if (!event.getSource().is(DamageTypes.DROWN)) continue;
                event.getEntity().setAirSupply(event.getEntity().getMaxAirSupply());
                event.setNewDamage(0.0f);
            }
        }
    }
}

