/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import com.supermartijn642.connectedglass.CGGlassType;
import cy.jdkdigital.dyenamics.common.block.DyenamicStainedGlassBlock;
import cy.jdkdigital.dyenamics.common.block.DyenamicStainedGlassPane;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.common.block.TintedDyenamicStainedGlassBlock;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ConnectedGlassCompat {
    public static final List<DeferredHolder<Block, ? extends Block>> GLASS_BLOCKS = new ArrayList<DeferredHolder<Block, ? extends Block>>();
    public static final List<DeferredHolder<Block, ? extends Block>> GLASS_PANES = new ArrayList<DeferredHolder<Block, ? extends Block>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        for (CGGlassType glassType : CGGlassType.values()) {
            String typeName = glassType.name().toLowerCase(Locale.ROOT);
            String prefix = "connectedglass_" + typeName + "_" + color.getSerializedName();
            DeferredHolder<Block, ? extends Block> block = DyenamicRegistry.registerBlock(prefix, () -> glassType.isTinted ? new TintedDyenamicStainedGlassBlock(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)) : new DyenamicStainedGlassBlock(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)), true);
            GLASS_BLOCKS.add(block);
            if (!glassType.hasPanes) continue;
            GLASS_PANES.add(DyenamicRegistry.registerBlock(prefix + "_pane", () -> new DyenamicStainedGlassPane(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS_PANE)), true));
        }
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.parse((String)"connectedglass:connectedglass"));
        if (event.getTabKey().equals(key)) {
            GLASS_BLOCKS.forEach(holder -> event.accept((ItemLike)holder.get()));
            GLASS_PANES.forEach(holder -> event.accept((ItemLike)holder.get()));
        }
    }

    public static class Client {
        public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            GLASS_BLOCKS.forEach(holder -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)holder.get()), (RenderType)RenderType.translucent()));
            GLASS_PANES.forEach(holder -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)holder.get()), (RenderType)RenderType.translucent()));
        }
    }
}

