/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbranks.PlayerNameFormatting;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import dev.ftb.mods.ftbranks.api.RankException;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.api.event.ConditionChangedEvent;
import dev.ftb.mods.ftbranks.api.event.PermissionNodeChangedEvent;
import dev.ftb.mods.ftbranks.api.event.PlayerAddedToRankEvent;
import dev.ftb.mods.ftbranks.api.event.PlayerRemovedFromRankEvent;
import dev.ftb.mods.ftbranks.api.event.RankEvent;
import dev.ftb.mods.ftbranks.impl.RankFileSource;
import dev.ftb.mods.ftbranks.impl.RankManagerImpl;
import dev.ftb.mods.ftbranks.impl.condition.AlwaysActiveCondition;
import dev.ftb.mods.ftbranks.impl.condition.DefaultCondition;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class RankImpl
implements Rank,
Comparable<RankImpl> {
    private static final Set<String> SPECIAL_FIELDS = Set.of("name", "power", "condition");
    private final RankManagerImpl manager;
    private final String id;
    private final Map<String, PermissionValue> permissions = new LinkedHashMap<String, PermissionValue>();
    private final String name;
    private final int power;
    private final RankFileSource source;
    @NotNull
    private RankCondition condition;

    public static RankImpl create(RankManagerImpl manager, String id, String name, int power, @NotNull RankCondition condition, RankFileSource source) {
        return new RankImpl(manager, id, name, power, condition, source);
    }

    public static RankImpl create(RankManagerImpl manager, String id, String name, int power, RankFileSource source) {
        RankImpl rank = new RankImpl(manager, id, name, power, AlwaysActiveCondition.INSTANCE, source);
        rank.setCondition(new DefaultCondition(rank));
        return rank;
    }

    private RankImpl(RankManagerImpl manager, String id, String name, int power, @NotNull RankCondition condition, RankFileSource source) {
        this.manager = manager;
        this.id = id;
        this.name = name;
        this.power = power;
        this.condition = condition;
        this.source = source;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Rank && this.id.equals(((Rank)o).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public RankManager getManager() {
        return this.manager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public void setPermission(String node, PermissionValue value) {
        if (node.equals("condition")) {
            throw new IllegalArgumentException("use '/ftbranks condition' to set conditions");
        }
        PermissionValue oldValue = this.getPermission(node);
        if (!oldValue.equals(value)) {
            if (value != null) {
                this.permissions.put(node, value);
            } else {
                this.permissions.remove(node);
            }
            ((Consumer)RankEvent.PERMISSION_CHANGED.invoker()).accept(new PermissionNodeChangedEvent(this.manager, this, node, oldValue, value));
            if (node.equals("ftbranks.name_format")) {
                PlayerNameFormatting.refreshPlayerNames();
            }
            this.manager.markRanksDirty();
        }
    }

    @Override
    @NotNull
    public PermissionValue getPermission(String node) {
        return this.permissions.getOrDefault(node, PermissionValue.MISSING);
    }

    @Override
    @NotNull
    public RankCondition getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(RankCondition newCondition) {
        RankCondition oldCondition = this.condition;
        this.condition = newCondition;
        ((Consumer)RankEvent.CONDITION_CHANGED.invoker()).accept(new ConditionChangedEvent(this.manager, this, oldCondition, newCondition));
        PlayerNameFormatting.refreshPlayerNames();
        this.manager.markRanksDirty();
    }

    @Override
    public boolean add(GameProfile profile) {
        if (this.manager.getOrCreatePlayerData(profile).addRank(this)) {
            ((Consumer)RankEvent.ADD_PLAYER.invoker()).accept(new PlayerAddedToRankEvent(this.manager, this, profile));
            PlayerNameFormatting.refreshPlayerNames();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(GameProfile profile) {
        if (this.manager.getOrCreatePlayerData(profile).removeRank(this)) {
            this.manager.markPlayerDataDirty();
            ((Consumer)RankEvent.REMOVE_PLAYER.invoker()).accept(new PlayerRemovedFromRankEvent(this.manager, (Rank)this, profile));
            PlayerNameFormatting.refreshPlayerNames();
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(RankImpl o) {
        return o.getPower() - this.getPower();
    }

    @Override
    public Collection<String> getPermissions() {
        HashSet<String> nodes = new HashSet<String>(this.permissions.keySet());
        nodes.removeAll(SPECIAL_FIELDS);
        return nodes;
    }

    public static RankImpl readSNBT(RankManagerImpl manager, String rankId, SNBTCompoundTag tag, RankFileSource source) throws RankException {
        String displayName = tag.getString("name").isEmpty() ? rankId : tag.getString("name");
        RankImpl rank = RankImpl.create(manager, rankId, displayName, tag.getInt("power"), source);
        if (tag.contains("condition")) {
            rank.setCondition(manager.createCondition(rank, tag.get("condition")));
        }
        for (String key : tag.getAllKeys()) {
            if (SPECIAL_FIELDS.contains(key)) continue;
            while (key.endsWith(".*")) {
                key = key.substring(0, key.length() - 2);
                manager.markRanksDirty();
            }
            if (key.isEmpty()) continue;
            rank.permissions.put(key, RankManagerImpl.ofTag(tag, key));
        }
        return rank;
    }

    public SNBTCompoundTag writeSNBT() {
        SNBTCompoundTag res = new SNBTCompoundTag();
        res.putString("name", this.name);
        res.putInt("power", this.power);
        if (!this.condition.isDefaultCondition()) {
            if (this.condition.isSimple()) {
                res.putString("condition", this.condition.getType());
            } else {
                SNBTCompoundTag c = new SNBTCompoundTag();
                c.putString("type", this.condition.getType());
                this.condition.save(c);
                res.put("condition", (Tag)c);
            }
        }
        RankManagerImpl.writePermissions(this.permissions, res);
        return res;
    }

    public RankFileSource getSource() {
        return this.source;
    }
}

