/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl.condition;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import dev.ftb.mods.ftbranks.api.RankException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class AndCondition
implements RankCondition {
    private final List<RankCondition> conditions = new ArrayList<RankCondition>();

    public AndCondition(Rank rank, SNBTCompoundTag tag) throws RankException {
        for (Tag t : tag.getList("conditions", Tag.class)) {
            this.conditions.add(rank.getManager().createCondition(rank, t));
        }
    }

    @Override
    public String getType() {
        return "and";
    }

    @Override
    public boolean isRankActive(ServerPlayer player) {
        return this.conditions.stream().allMatch(condition -> condition.isRankActive(player));
    }

    @Override
    public void save(SNBTCompoundTag tag) {
        ListTag a = new ListTag();
        for (RankCondition condition : this.conditions) {
            SNBTCompoundTag c = new SNBTCompoundTag();
            c.putString("type", condition.getType());
            condition.save(c);
            a.add((Object)c);
        }
        tag.put("conditions", (Tag)a);
    }
}

