/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl.condition;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import net.minecraft.server.level.ServerPlayer;

public class RankAddedCondition
implements RankCondition {
    protected final Rank original;
    protected final String id;

    public RankAddedCondition(Rank r, SNBTCompoundTag tag) {
        this.original = r;
        this.id = tag.getString("rank");
    }

    @Override
    public String getType() {
        return "rank_added";
    }

    @Override
    public boolean isRankActive(ServerPlayer player) {
        return this.original.getManager().getRank(this.id).map(rank -> rank != this.original && rank.isAdded(player)).orElse(false);
    }

    @Override
    public void save(SNBTCompoundTag tag) {
        tag.putString("rank", this.id);
    }
}

