/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.compat.jei;

import cy.jdkdigital.treetap.TreeTap;
import cy.jdkdigital.treetap.common.recipe.TapExtractRecipe;
import cy.jdkdigital.treetap.compat.CompatHandler;
import cy.jdkdigital.treetap.compat.jei.TreeTapJeiPlugin;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class TapExtractRecipeCategory
implements IRecipeCategory<TapExtractRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public TapExtractRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"treetap", (String)"textures/gui/jei/tap_extract.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)TreeTap.TAP_ITEM.get()));
    }

    public RecipeType<TapExtractRecipe> getRecipeType() {
        return TreeTapJeiPlugin.TAP_EXTRACT_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)"jei.treetap.tap_extract");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TapExtractRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 18, 27).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, List.of(recipe.input.getItems()))).setSlotName("log");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 27).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, recipe.woodenItemOutput.isEmpty() ? List.of(recipe.itemOutput.copy()) : List.of(recipe.itemOutput.copy(), recipe.woodenItemOutput.copy()))).setSlotName("output");
        IFluidHandlerItem cap = (IFluidHandlerItem)recipe.itemOutput.getCapability(Capabilities.FluidHandler.ITEM);
        if (cap != null) {
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack(cap.getFluidInTank(0).getFluid(), cap.getTankCapacity(0)));
        }
    }

    public void draw(TapExtractRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        CompatHandler.showRecipeText(guiGraphics, recipe);
    }
}

