/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.RegistryRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.containers.base.RelicContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.fluids.FluidType;

public class RelicExperienceOrbEntity
extends Entity {
    private static final EntityDataAccessor<Integer> EXPERIENCE = SynchedEntityData.defineId(RelicExperienceOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public RelicExperienceOrbEntity(EntityType<? extends RelicExperienceOrbEntity> type, Level level) {
        super(type, level);
    }

    public static int getMaxExperience() {
        return 10;
    }

    public int getExperience() {
        return (Integer)this.getEntityData().get(EXPERIENCE);
    }

    public void setExperience(int experience) {
        this.getEntityData().set(EXPERIENCE, (Object)experience);
    }

    public int getStage() {
        int stages = 5;
        return Mth.clamp((int)(this.getExperience() <= 1 ? 1 : Math.min(this.getExperience() / (RelicExperienceOrbEntity.getMaxExperience() / Math.max(1, stages - 1)) + 1, stages)), (int)1, (int)stages);
    }

    private List<ItemStack> getUpgradeableRelics(Player player) {
        ArrayList<ItemStack> relics = new ArrayList<ItemStack>();
        for (RelicContainer source : RegistryRegistry.RELIC_CONTAINER_REGISTRY.entrySet().stream().map(Map.Entry::getValue).toList()) {
            relics.addAll(source.gatherRelics().apply((LivingEntity)player).stream().filter(entry -> !((IRelicItem)entry.getItem()).isRelicMaxLevel((ItemStack)entry)).toList());
        }
        return relics;
    }

    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        }
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        if (this.tickCount >= 15) {
            if (this.getExperience() < RelicExperienceOrbEntity.getMaxExperience()) {
                for (RelicExperienceOrbEntity orb : this.level().getEntitiesOfClass(RelicExperienceOrbEntity.class, this.getBoundingBox())) {
                    if (orb.getUUID().equals(this.getUUID()) || orb.isRemoved() || orb.getExperience() >= RelicExperienceOrbEntity.getMaxExperience()) continue;
                    int diff = RelicExperienceOrbEntity.getMaxExperience() - this.getExperience();
                    if (orb.getExperience() < diff) {
                        this.setExperience(this.getExperience() + orb.getExperience());
                        orb.discard();
                        continue;
                    }
                    orb.setExperience(orb.getExperience() - diff);
                    this.setExperience(RelicExperienceOrbEntity.getMaxExperience());
                }
            }
            double maxDistance = 16.0;
            Player player = this.level().getNearestPlayer(this.getX(), this.getY(), this.getZ(), maxDistance, entity -> {
                Player entry = (Player)entity;
                return !entry.isSpectator() && !this.getUpgradeableRelics(entry).isEmpty();
            });
            if (player != null) {
                List<ItemStack> upgradeable;
                this.setDeltaMovement(this.getDeltaMovement().add(player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0).subtract(this.position()).normalize().scale((maxDistance - this.position().distanceTo(player.position())) / (maxDistance * 10.0))));
                if (this.position().distanceTo(player.position()) <= (double)(player.getBbWidth() * 1.25f) && !(upgradeable = this.getUpgradeableRelics(player)).isEmpty()) {
                    ItemStack stack = upgradeable.get(this.random.nextInt(upgradeable.size()));
                    ((IRelicItem)stack.getItem()).spreadRelicExperience((LivingEntity)player, stack, this.getExperience());
                    this.discard();
                    this.level().playSound(null, this.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.MASTER, 0.5f, 1.25f + this.level().getRandom().nextFloat() * 0.75f);
                }
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float friction = 0.98f;
        if (this.onGround()) {
            BlockPos pos = this.getBlockPosBelowThatAffectsMyMovement();
            friction = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)friction, 0.98, (double)friction));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        if (this.tickCount >= 1000) {
            this.discard();
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setExperience(tag.getInt("experience"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("experience", this.getExperience());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(EXPERIENCE, (Object)0);
    }

    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999f);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isAttackable() {
        return false;
    }

    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (EXPERIENCE.equals(pKey)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(pKey);
    }

    public EntityDimensions getDimensions(Pose pPose) {
        float scale = 0.15f + (float)this.getStage() * 0.05f;
        return EntityDimensions.scalable((float)scale, (float)scale);
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        double d0 = this.getBoundingBox().inflate((double)0.2f).getSize();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }
}

