/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.research;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketManageLink
implements CustomPacketPayload {
    private final int container;
    private final int slot;
    private final String ability;
    private final Operation operation;
    private final int from;
    private final int to;
    public static final CustomPacketPayload.Type<PacketManageLink> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"manage_link"));
    public static final StreamCodec<ByteBuf, PacketManageLink> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PacketManageLink::getContainer, (StreamCodec)ByteBufCodecs.INT, PacketManageLink::getSlot, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketManageLink::getAbility, (StreamCodec)ByteBufCodecs.idMapper(Operation.BY_ID, Operation::getId), PacketManageLink::getOperation, (StreamCodec)ByteBufCodecs.INT, PacketManageLink::getFrom, (StreamCodec)ByteBufCodecs.INT, PacketManageLink::getTo, PacketManageLink::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.player().level().isClientSide()) {
                return;
            }
            ServerPlayer player = (ServerPlayer)ctx.player();
            if (player.containerMenu.containerId != this.container) {
                PacketManageLink.causeError((Player)player);
                return;
            }
            ItemStack stack = DescriptionUtils.gatherRelicStack((Player)player, this.slot);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                PacketManageLink.causeError((Player)player);
                return;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            RandomSource random = player.getRandom();
            switch (this.operation.ordinal()) {
                case 0: {
                    relic.addResearchLink(stack, this.ability, this.from, this.to);
                    if (relic.testAbilityResearch(stack, this.ability)) {
                        relic.setAbilityResearched(stack, this.ability, true);
                        player.connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)((SoundEvent)SoundRegistry.FINISH_RESEARCH.get())), SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, random.nextLong()));
                        break;
                    }
                    player.connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)((SoundEvent)SoundRegistry.CONNECT_STARS.get())), SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 0.75f, 0.75f + random.nextFloat() * 0.5f, random.nextLong()));
                    break;
                }
                case 1: {
                    relic.removeResearchLink(stack, this.ability, this.from, this.to);
                }
            }
            try {
                player.containerMenu.getSlot(this.slot).set(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                PacketManageLink.causeError((Player)player);
            }
        });
    }

    private static void causeError(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"info.relics.researching.wrong_container").withStyle(ChatFormatting.RED), false);
        player.closeContainer();
    }

    public int getContainer() {
        return this.container;
    }

    public int getSlot() {
        return this.slot;
    }

    public String getAbility() {
        return this.ability;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketManageLink)) {
            return false;
        }
        PacketManageLink other = (PacketManageLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainer() != other.getContainer()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.getFrom() != other.getFrom()) {
            return false;
        }
        if (this.getTo() != other.getTo()) {
            return false;
        }
        String this$ability = this.getAbility();
        String other$ability = other.getAbility();
        if (this$ability == null ? other$ability != null : !this$ability.equals(other$ability)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PacketManageLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainer();
        result = result * 59 + this.getSlot();
        result = result * 59 + this.getFrom();
        result = result * 59 + this.getTo();
        String $ability = this.getAbility();
        result = result * 59 + ($ability == null ? 43 : $ability.hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    public String toString() {
        return "PacketManageLink(container=" + this.getContainer() + ", slot=" + this.getSlot() + ", ability=" + this.getAbility() + ", operation=" + String.valueOf((Object)this.getOperation()) + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }

    public PacketManageLink(int container, int slot, String ability, Operation operation, int from, int to) {
        this.container = container;
        this.slot = slot;
        this.ability = ability;
        this.operation = operation;
        this.from = from;
        this.to = to;
    }

    public static enum Operation {
        ADD(0),
        REMOVE(1);

        public static final IntFunction<Operation> BY_ID;
        private final int id;

        public int getId() {
            return this.id;
        }

        private Operation(int id) {
            this.id = id;
        }

        static {
            BY_ID = ByIdMap.continuous(Operation::getId, (Object[])Operation.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

