/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile;

import dev.djefrey.colorwheel.ShaderType;
import dev.djefrey.colorwheel.compile.ClrwlPipelineStage;
import dev.djefrey.colorwheel.compile.ClrwlShaderKey;
import dev.engine_room.flywheel.backend.glsl.GlslVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record ClrwlPipeline(String id, GlslVersion minVersion, List<String> extensions, ClrwlPipelineStage<ClrwlShaderKey> vertex, ClrwlPipelineStage<ClrwlShaderKey> geometry, ClrwlPipelineStage<ClrwlShaderKey> fragment) {
    public static ClrwlPipelineStage.Builder<ClrwlShaderKey> vertexStage() {
        return new ClrwlPipelineStage.Builder<ClrwlShaderKey>(ShaderType.VERTEX);
    }

    public static ClrwlPipelineStage.Builder<ClrwlShaderKey> geometryStage() {
        return new ClrwlPipelineStage.Builder<ClrwlShaderKey>(ShaderType.GEOMETRY);
    }

    public static ClrwlPipelineStage.Builder<ClrwlShaderKey> fragmentStage() {
        return new ClrwlPipelineStage.Builder<ClrwlShaderKey>(ShaderType.FRAGMENT);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private GlslVersion minVersion;
        private final List<String> extensions = new ArrayList<String>();
        private ClrwlPipelineStage<ClrwlShaderKey> vertex;
        private ClrwlPipelineStage<ClrwlShaderKey> geometry;
        private ClrwlPipelineStage<ClrwlShaderKey> fragment;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder minVersion(GlslVersion minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        public Builder requireExtension(String extension) {
            this.extensions.add(extension);
            return this;
        }

        public Builder onSetup(Consumer<Builder> consume) {
            consume.accept(this);
            return this;
        }

        public Builder vertex(ClrwlPipelineStage<ClrwlShaderKey> stage) {
            this.vertex = stage;
            return this;
        }

        public Builder geometry(ClrwlPipelineStage<ClrwlShaderKey> stage) {
            this.geometry = stage;
            return this;
        }

        public Builder fragment(ClrwlPipelineStage<ClrwlShaderKey> stage) {
            this.fragment = stage;
            return this;
        }

        public ClrwlPipeline build() {
            Objects.requireNonNull(this.id);
            Objects.requireNonNull(this.minVersion);
            Objects.requireNonNull(this.extensions);
            Objects.requireNonNull(this.vertex);
            Objects.requireNonNull(this.geometry);
            Objects.requireNonNull(this.fragment);
            return new ClrwlPipeline(this.id, this.minVersion, this.extensions, this.vertex, this.geometry, this.fragment);
        }
    }
}

