/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine.uniform;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.djefrey.colorwheel.engine.uniform.DebugMode;
import dev.djefrey.colorwheel.engine.uniform.UniformWriter;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.backend.engine.indirect.DepthPyramid;
import dev.engine_room.flywheel.backend.engine.uniform.UniformBuffer;
import dev.engine_room.flywheel.backend.mixin.LevelRendererAccessor;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;
import net.irisshaders.iris.shaderpack.properties.PackDirectives;
import net.irisshaders.iris.shadows.ShadowMatrices;
import net.irisshaders.iris.shadows.ShadowRenderer;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryUtil;

public final class ClrwlFrameUniforms
extends UniformWriter {
    private static final int SIZE = 1168;
    public static final UniformBuffer BUFFER = new UniformBuffer(0, 1168);
    private static final Matrix4f VIEW = new Matrix4f();
    private static final Matrix4f VIEW_INVERSE = new Matrix4f();
    private static final Matrix4f VIEW_PREV = new Matrix4f();
    private static final Matrix4f PROJECTION = new Matrix4f();
    private static final Matrix4f PROJECTION_INVERSE = new Matrix4f();
    private static final Matrix4f PROJECTION_PREV = new Matrix4f();
    private static final Matrix4f VIEW_PROJECTION = new Matrix4f();
    private static final Matrix4f VIEW_PROJECTION_INVERSE = new Matrix4f();
    private static final Matrix4f VIEW_PROJECTION_PREV = new Matrix4f();
    private static final Matrix4f SHADOW_VIEW = new Matrix4f();
    private static final Matrix4f SHADOW_VIEW_INVERSE = new Matrix4f();
    private static final Matrix4f SHADOW_PROJECTION = new Matrix4f();
    private static final Matrix4f SHADOW_PROJECTION_INVERSE = new Matrix4f();
    private static final Matrix3f NORMAL = new Matrix3f();
    private static final Vector3f CAMERA_POS = new Vector3f();
    private static final Vector3f CAMERA_POS_PREV = new Vector3f();
    private static final Vector3f CAMERA_LOOK = new Vector3f();
    private static final Vector3f CAMERA_LOOK_PREV = new Vector3f();
    private static final Vector2f CAMERA_ROT = new Vector2f();
    private static final Vector2f CAMERA_ROT_PREV = new Vector2f();
    private static boolean firstWrite = true;
    private static int debugMode = DebugMode.OFF.ordinal();
    private static boolean frustumPaused = false;
    private static boolean frustumCapture = false;

    private ClrwlFrameUniforms() {
    }

    public static void debugMode(DebugMode mode) {
        debugMode = mode.ordinal();
    }

    public static void captureFrustum() {
        frustumPaused = true;
        frustumCapture = true;
    }

    public static void unpauseFrustum() {
        frustumPaused = false;
    }

    public static void update(RenderContext context, ShaderPack pack, NamespacedId dimension) {
        PackDirectives directives = pack.getProgramSet(dimension).getPackDirectives();
        long ptr = BUFFER.ptr();
        ClrwlFrameUniforms.setPrev();
        Vec3i renderOrigin = VisualizationManager.getOrThrow((LevelAccessor)context.level()).renderOrigin();
        Camera camera = context.camera();
        Vec3 cameraPos = camera.getPosition();
        float camX = (float)(cameraPos.x - (double)renderOrigin.getX());
        float camY = (float)(cameraPos.y - (double)renderOrigin.getY());
        float camZ = (float)(cameraPos.z - (double)renderOrigin.getZ());
        VIEW.set(context.modelView());
        VIEW.translate(-camX, -camY, -camZ);
        PROJECTION.set(context.projection());
        VIEW_PROJECTION.set(context.viewProjection());
        VIEW_PROJECTION.translate(-camX, -camY, -camZ);
        PoseStack shadowModelView = ShadowRenderer.createShadowModelView((float)directives.getSunPathRotation(), (float)directives.getShadowDirectives().getIntervalSize(), (float)directives.getShadowDirectives().getNearPlane(), (float)directives.getShadowDirectives().getFarPlane());
        Matrix4f shadowProjection = ShadowMatrices.createOrthoMatrix((float)directives.getShadowDirectives().getDistance(), (float)directives.getShadowDirectives().getNearPlane(), (float)directives.getShadowDirectives().getFarPlane());
        SHADOW_VIEW.set((Matrix4fc)shadowModelView.last().pose());
        SHADOW_VIEW.translate(-camX, -camY, -camZ);
        SHADOW_PROJECTION.set((Matrix4fc)shadowProjection);
        Matrix4f normal = new Matrix4f(context.modelView()).translate(-camX, -camY, -camZ).invert().transpose();
        normal.get3x3(NORMAL);
        CAMERA_POS.set(camX, camY, camZ);
        CAMERA_LOOK.set((Vector3fc)camera.getLookVector());
        CAMERA_ROT.set(camera.getXRot(), camera.getYRot());
        if (firstWrite) {
            ClrwlFrameUniforms.setPrev();
        }
        if (firstWrite || !frustumPaused || frustumCapture) {
            ClrwlFrameUniforms.writePackedFrustumPlanes(ptr, VIEW_PROJECTION);
            frustumCapture = false;
        }
        ptr += 96L;
        ptr = ClrwlFrameUniforms.writeCullData(ptr);
        ptr = ClrwlFrameUniforms.writeMatrices(ptr);
        ptr = ClrwlFrameUniforms.writeRenderOrigin(ptr, renderOrigin);
        ptr = ClrwlFrameUniforms.writeCamera(ptr);
        Window window = Minecraft.getInstance().getWindow();
        ptr = ClrwlFrameUniforms.writeVec2(ptr, window.getWidth(), window.getHeight());
        ptr = ClrwlFrameUniforms.writeFloat(ptr, (float)window.getWidth() / (float)window.getHeight());
        ptr = ClrwlFrameUniforms.writeFloat(ptr, Math.max((float)2.5f, (float)((float)window.getWidth() / 1920.0f * 2.5f)));
        ptr = ClrwlFrameUniforms.writeFloat(ptr, Minecraft.getInstance().gameRenderer.getDepthFar());
        ptr = ClrwlFrameUniforms.writeTime(ptr, context);
        ptr = ClrwlFrameUniforms.writeCameraIn(ptr, camera);
        ptr = ClrwlFrameUniforms.writeInt(ptr, debugMode);
        ptr = ClrwlFrameUniforms.writeFloat(ptr, 0.07f);
        firstWrite = false;
        BUFFER.markDirty();
    }

    private static long writeRenderOrigin(long ptr, Vec3i renderOrigin) {
        ptr = ClrwlFrameUniforms.writeIVec3(ptr, renderOrigin.getX(), renderOrigin.getY(), renderOrigin.getZ());
        return ptr;
    }

    private static void setPrev() {
        VIEW_PREV.set((Matrix4fc)VIEW);
        PROJECTION_PREV.set((Matrix4fc)PROJECTION);
        VIEW_PROJECTION_PREV.set((Matrix4fc)VIEW_PROJECTION);
        CAMERA_POS_PREV.set((Vector3fc)CAMERA_POS);
        CAMERA_LOOK_PREV.set((Vector3fc)CAMERA_LOOK);
        CAMERA_ROT_PREV.set((Vector2fc)CAMERA_ROT);
    }

    private static long writeMatrices(long ptr) {
        ptr = ClrwlFrameUniforms.writeMat4(ptr, VIEW);
        ptr = ClrwlFrameUniforms.writeMat4(ptr, VIEW.invert(VIEW_INVERSE));
        ptr = ClrwlFrameUniforms.writeMat4(ptr, VIEW_PREV);
        ptr = ClrwlFrameUniforms.writeMat4(ptr, PROJECTION);
        ptr = ClrwlFrameUniforms.writeMat4(ptr, PROJECTION.invert(PROJECTION_INVERSE));
        ptr = ClrwlFrameUniforms.writeMat4(ptr, PROJECTION_PREV);
        ptr = ClrwlFrameUniforms.writeMat4(ptr, VIEW_PROJECTION);
        ptr = ClrwlFrameUniforms.writeMat4(ptr, VIEW_PROJECTION.invert(VIEW_PROJECTION_INVERSE));
        ptr = ClrwlFrameUniforms.writeMat4(ptr, VIEW_PROJECTION_PREV);
        ptr = ClrwlFrameUniforms.writeMat4(ptr, SHADOW_VIEW);
        ptr = ClrwlFrameUniforms.writeMat4(ptr, SHADOW_VIEW.invert(SHADOW_VIEW_INVERSE));
        ptr = ClrwlFrameUniforms.writeMat4(ptr, SHADOW_PROJECTION);
        ptr = ClrwlFrameUniforms.writeMat4(ptr, SHADOW_PROJECTION.invert(SHADOW_PROJECTION_INVERSE));
        ptr = ClrwlFrameUniforms.writeMat3(ptr, NORMAL);
        return ptr;
    }

    private static long writeCamera(long ptr) {
        ptr = ClrwlFrameUniforms.writeVec3(ptr, ClrwlFrameUniforms.CAMERA_POS.x, ClrwlFrameUniforms.CAMERA_POS.y, ClrwlFrameUniforms.CAMERA_POS.z);
        ptr = ClrwlFrameUniforms.writeVec3(ptr, ClrwlFrameUniforms.CAMERA_POS_PREV.x, ClrwlFrameUniforms.CAMERA_POS_PREV.y, ClrwlFrameUniforms.CAMERA_POS_PREV.z);
        ptr = ClrwlFrameUniforms.writeVec3(ptr, ClrwlFrameUniforms.CAMERA_LOOK.x, ClrwlFrameUniforms.CAMERA_LOOK.y, ClrwlFrameUniforms.CAMERA_LOOK.z);
        ptr = ClrwlFrameUniforms.writeVec3(ptr, ClrwlFrameUniforms.CAMERA_LOOK_PREV.x, ClrwlFrameUniforms.CAMERA_LOOK_PREV.y, ClrwlFrameUniforms.CAMERA_LOOK_PREV.z);
        ptr = ClrwlFrameUniforms.writeVec2(ptr, ClrwlFrameUniforms.CAMERA_ROT.x, ClrwlFrameUniforms.CAMERA_ROT.y);
        ptr = ClrwlFrameUniforms.writeVec2(ptr, ClrwlFrameUniforms.CAMERA_ROT_PREV.x, ClrwlFrameUniforms.CAMERA_ROT_PREV.y);
        return ptr;
    }

    private static long writeTime(long ptr, RenderContext context) {
        int ticks = ((LevelRendererAccessor)context.renderer()).flywheel$getTicks();
        float partialTick = context.partialTick();
        float renderTicks = (float)ticks + partialTick;
        float renderSeconds = renderTicks / 20.0f;
        float systemSeconds = (float)Util.getMillis() / 1000.0f;
        int systemMillis = (int)(Util.getMillis() % Integer.MAX_VALUE);
        ptr = ClrwlFrameUniforms.writeInt(ptr, ticks);
        ptr = ClrwlFrameUniforms.writeFloat(ptr, partialTick);
        ptr = ClrwlFrameUniforms.writeFloat(ptr, renderTicks);
        ptr = ClrwlFrameUniforms.writeFloat(ptr, renderSeconds);
        ptr = ClrwlFrameUniforms.writeFloat(ptr, systemSeconds);
        ptr = ClrwlFrameUniforms.writeInt(ptr, systemMillis);
        return ptr;
    }

    private static long writeCameraIn(long ptr, Camera camera) {
        if (!camera.isInitialized()) {
            ptr = ClrwlFrameUniforms.writeInt(ptr, 0);
            ptr = ClrwlFrameUniforms.writeInt(ptr, 0);
            return ptr;
        }
        Level level = camera.getEntity().level();
        BlockPos blockPos = camera.getBlockPosition();
        Vec3 cameraPos = camera.getPosition();
        return ClrwlFrameUniforms.writeInFluidAndBlock(ptr, level, blockPos, cameraPos);
    }

    private static long writeCullData(long ptr) {
        Minecraft mc = Minecraft.getInstance();
        RenderTarget mainRenderTarget = mc.getMainRenderTarget();
        int pyramidWidth = DepthPyramid.mip0Size((int)mainRenderTarget.width);
        int pyramidHeight = DepthPyramid.mip0Size((int)mainRenderTarget.height);
        int pyramidDepth = DepthPyramid.getImageMipLevels((int)pyramidWidth, (int)pyramidHeight);
        ptr = ClrwlFrameUniforms.writeFloat(ptr, 0.05f);
        ptr = ClrwlFrameUniforms.writeFloat(ptr, mc.gameRenderer.getDepthFar());
        ptr = ClrwlFrameUniforms.writeFloat(ptr, PROJECTION.m00());
        ptr = ClrwlFrameUniforms.writeFloat(ptr, PROJECTION.m11());
        ptr = ClrwlFrameUniforms.writeFloat(ptr, pyramidWidth);
        ptr = ClrwlFrameUniforms.writeFloat(ptr, pyramidHeight);
        ptr = ClrwlFrameUniforms.writeInt(ptr, pyramidDepth - 1);
        ptr = ClrwlFrameUniforms.writeInt(ptr, 0);
        return ptr;
    }

    private static void writePackedFrustumPlanes(long ptr, Matrix4f m) {
        float nxX = m.m03() + m.m00();
        float nxY = m.m13() + m.m10();
        float nxZ = m.m23() + m.m20();
        float nxW = m.m33() + m.m30();
        float invl = Math.invsqrt((float)(nxX * nxX + nxY * nxY + nxZ * nxZ));
        nxX *= invl;
        nxY *= invl;
        nxZ *= invl;
        nxW *= invl;
        float pxX = m.m03() - m.m00();
        float pxY = m.m13() - m.m10();
        float pxZ = m.m23() - m.m20();
        float pxW = m.m33() - m.m30();
        invl = Math.invsqrt((float)(pxX * pxX + pxY * pxY + pxZ * pxZ));
        pxX *= invl;
        pxY *= invl;
        pxZ *= invl;
        pxW *= invl;
        float nyX = m.m03() + m.m01();
        float nyY = m.m13() + m.m11();
        float nyZ = m.m23() + m.m21();
        float nyW = m.m33() + m.m31();
        invl = Math.invsqrt((float)(nyX * nyX + nyY * nyY + nyZ * nyZ));
        nyX *= invl;
        nyY *= invl;
        nyZ *= invl;
        nyW *= invl;
        float pyX = m.m03() - m.m01();
        float pyY = m.m13() - m.m11();
        float pyZ = m.m23() - m.m21();
        float pyW = m.m33() - m.m31();
        invl = Math.invsqrt((float)(pyX * pyX + pyY * pyY + pyZ * pyZ));
        pyX *= invl;
        pyY *= invl;
        pyZ *= invl;
        pyW *= invl;
        float nzX = m.m03() + m.m02();
        float nzY = m.m13() + m.m12();
        float nzZ = m.m23() + m.m22();
        float nzW = m.m33() + m.m32();
        invl = Math.invsqrt((float)(nzX * nzX + nzY * nzY + nzZ * nzZ));
        nzX *= invl;
        nzY *= invl;
        nzZ *= invl;
        nzW *= invl;
        float pzX = m.m03() - m.m02();
        float pzY = m.m13() - m.m12();
        float pzZ = m.m23() - m.m22();
        float pzW = m.m33() - m.m32();
        invl = Math.invsqrt((float)(pzX * pzX + pzY * pzY + pzZ * pzZ));
        pzX *= invl;
        pzY *= invl;
        pzZ *= invl;
        pzW *= invl;
        MemoryUtil.memPutFloat((long)ptr, (float)nxX);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)pxX);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)nyX);
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)pyX);
        MemoryUtil.memPutFloat((long)(ptr + 16L), (float)nxY);
        MemoryUtil.memPutFloat((long)(ptr + 20L), (float)pxY);
        MemoryUtil.memPutFloat((long)(ptr + 24L), (float)nyY);
        MemoryUtil.memPutFloat((long)(ptr + 28L), (float)pyY);
        MemoryUtil.memPutFloat((long)(ptr + 32L), (float)nxZ);
        MemoryUtil.memPutFloat((long)(ptr + 36L), (float)pxZ);
        MemoryUtil.memPutFloat((long)(ptr + 40L), (float)nyZ);
        MemoryUtil.memPutFloat((long)(ptr + 44L), (float)pyZ);
        MemoryUtil.memPutFloat((long)(ptr + 48L), (float)nxW);
        MemoryUtil.memPutFloat((long)(ptr + 52L), (float)pxW);
        MemoryUtil.memPutFloat((long)(ptr + 56L), (float)nyW);
        MemoryUtil.memPutFloat((long)(ptr + 60L), (float)pyW);
        MemoryUtil.memPutFloat((long)(ptr + 64L), (float)nzX);
        MemoryUtil.memPutFloat((long)(ptr + 68L), (float)pzX);
        MemoryUtil.memPutFloat((long)(ptr + 72L), (float)nzY);
        MemoryUtil.memPutFloat((long)(ptr + 76L), (float)pzY);
        MemoryUtil.memPutFloat((long)(ptr + 80L), (float)nzZ);
        MemoryUtil.memPutFloat((long)(ptr + 84L), (float)pzZ);
        MemoryUtil.memPutFloat((long)(ptr + 88L), (float)nzW);
        MemoryUtil.memPutFloat((long)(ptr + 92L), (float)pzW);
    }

    public static boolean debugOn() {
        return debugMode != DebugMode.OFF.ordinal();
    }
}

