/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine.uniform;

import dev.djefrey.colorwheel.engine.uniform.UniformWriter;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.backend.engine.uniform.UniformBuffer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class ClrwlLevelUniforms
extends UniformWriter {
    private static final int SIZE = 112;
    static final UniformBuffer BUFFER = new UniformBuffer(1, 112);
    public static final Vector3f LIGHT0_DIRECTION = new Vector3f();
    public static final Vector3f LIGHT1_DIRECTION = new Vector3f();

    private ClrwlLevelUniforms() {
    }

    public static void update(RenderContext context) {
        long ptr = BUFFER.ptr();
        ClientLevel level = context.level();
        float partialTick = context.partialTick();
        Vec3 skyColor = level.getSkyColor(context.camera().getPosition(), partialTick);
        Vec3 cloudColor = level.getCloudColor(partialTick);
        ptr = ClrwlLevelUniforms.writeVec4(ptr, (float)skyColor.x, (float)skyColor.y, (float)skyColor.z, 1.0f);
        ptr = ClrwlLevelUniforms.writeVec4(ptr, (float)cloudColor.x, (float)cloudColor.y, (float)cloudColor.z, 1.0f);
        ptr = ClrwlLevelUniforms.writeVec3(ptr, (Vector3fc)LIGHT0_DIRECTION);
        ptr = ClrwlLevelUniforms.writeVec3(ptr, (Vector3fc)LIGHT1_DIRECTION);
        long dayTime = level.getDayTime();
        long levelDay = dayTime / 24000L;
        float timeOfDay = (float)(dayTime - levelDay * 24000L) / 24000.0f;
        ptr = ClrwlLevelUniforms.writeInt(ptr, (int)(levelDay % Integer.MAX_VALUE));
        ptr = ClrwlLevelUniforms.writeFloat(ptr, timeOfDay);
        ptr = ClrwlLevelUniforms.writeInt(ptr, level.dimensionType().hasSkyLight() ? 1 : 0);
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.getSunAngle(partialTick));
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.getMoonBrightness());
        ptr = ClrwlLevelUniforms.writeInt(ptr, level.getMoonPhase());
        ptr = ClrwlLevelUniforms.writeInt(ptr, level.isRaining() ? 1 : 0);
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.getRainLevel(partialTick));
        ptr = ClrwlLevelUniforms.writeInt(ptr, level.isThundering() ? 1 : 0);
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.getThunderLevel(partialTick));
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.getSkyDarken(partialTick));
        ptr = ClrwlLevelUniforms.writeInt(ptr, level.effects().constantAmbientLight() ? 1 : 0);
        ResourceKey dimension = level.dimension();
        int dimensionId = Level.OVERWORLD.equals(dimension) ? 0 : (Level.NETHER.equals(dimension) ? 1 : (Level.END.equals(dimension) ? 2 : -1));
        ptr = ClrwlLevelUniforms.writeInt(ptr, dimensionId);
        BUFFER.markDirty();
    }
}

