/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.effects;

import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class EffectPlow
extends AbstractEffect {
    public static final EffectPlow INSTANCE = new EffectPlow();

    public EffectPlow() {
        super(CompatRL.neg("plow"), "Plow");
    }

    public String getName() {
        return "Plow";
    }

    public String getBookDescription() {
        return "Simulate the use of an Hoe on blocks.";
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        for (BlockPos p : SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)rayTraceResult.getBlockPos(), (BlockHitResult)rayTraceResult, (double)spellStats.getAoeMultiplier(), (int)spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE))) {
            this.doTill(p, world, shooter, spellStats, spellContext, resolver);
        }
    }

    private boolean dupeCheck(Level world, BlockPos pos) {
        BlockEntity be = world.getBlockEntity(pos);
        return be != null && (world.getCapability(Capabilities.ItemHandler.BLOCK, pos, null) != null || be instanceof Container);
    }

    public void doTill(BlockPos p, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ItemStack hoe = new ItemStack((ItemLike)Items.DIAMOND_HOE);
        this.applyEnchantments(world, spellStats, hoe);
        FakePlayer entity = ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world), (UUID)shooter.getUUID());
        entity.setItemInHand(InteractionHand.MAIN_HAND, hoe);
        if (this.dupeCheck(world, p) || !BlockUtil.destroyRespectsClaim((LivingEntity)entity, (Level)world, (BlockPos)p)) {
            return;
        }
        entity.setPos((double)p.getX(), (double)p.getY(), (double)p.getZ());
        BlockHitResult rayTraceResult = new BlockHitResult(entity.position(), Direction.UP, p, false);
        if (world.getBlockState(p).useItemOn(hoe, world, (Player)entity, InteractionHand.MAIN_HAND, rayTraceResult) != ItemInteractionResult.FAIL) {
            hoe.useOn(new UseOnContext((Player)entity, InteractionHand.MAIN_HAND, rayTraceResult));
        }
    }

    public int getDefaultManaCost() {
        return 0;
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_EARTH});
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(new AbstractAugment[]{AugmentAOE.INSTANCE});
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the area of effect.");
    }
}

