/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.propagators;

import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.common.glyphs.forms.MethodMissile;
import alexthw.not_enough_glyphs.common.spell.MissileProjectile;
import com.alexthw.sauce.api.IPropagator;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropagateMissile
extends AbstractEffect
implements IPropagator {
    public static final PropagateMissile INSTANCE = new PropagateMissile();

    public PropagateMissile() {
        super(CompatRL.omega("propagate_missile"), "Propagate Missile");
    }

    public AbstractCastMethod getCastType() {
        return MethodMissile.INSTANCE;
    }

    public String getBookDescription() {
        return "Convert the remainder of the spell into a Missile spell and shoot it from where it resolves towards where the caster is looking.";
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        MethodMissile.INSTANCE.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentExtract.INSTANCE, "Projectile direction will be relative to caster position.");
    }

    public Integer getTypeIndex() {
        return 8;
    }

    public void propagate(Level world, HitResult hitResult, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        Vec3 pos = hitResult.getLocation();
        ArrayList<MissileProjectile> projectiles = new ArrayList<MissileProjectile>();
        int numSplits = stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        int opposite = -1;
        int counter = 0;
        for (int i = 0; i < numSplits + 1; ++i) {
            MissileProjectile spell = new MissileProjectile(world, resolver);
            projectiles.add(spell);
        }
        float velocity = MethodMissile.getProjectileSpeed(stats);
        boolean gravity = stats.hasBuff((AbstractAugment)AugmentDampen.INSTANCE);
        Vec3 direction = IPropagator.getDirection((LivingEntity)shooter, (SpellResolver)resolver, (Vec3)pos);
        for (MissileProjectile proj : projectiles) {
            proj.setPos(pos.add(0.0, 1.0, 0.0));
            if (shooter instanceof FakePlayer || stats.hasBuff((AbstractAugment)AugmentExtract.INSTANCE)) {
                proj.shoot(direction.x, direction.y, direction.z, velocity, 0.8f);
            } else {
                proj.shoot((Entity)shooter, shooter.getXRot(), shooter.getYRot() + (float)(Math.round((double)counter / 2.0) * 5L * (long)opposite), 0.0f, velocity, 0.8f);
            }
            opposite *= -1;
            ++counter;
            proj.setGravity(gravity);
            world.addFreshEntity((Entity)proj);
        }
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public int getDefaultManaCost() {
        return 200;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return MethodMissile.INSTANCE.getCompatibleAugments();
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public Glyph getGlyph() {
        if (this.glyphItem == null) {
            this.glyphItem = new Glyph(this, (AbstractSpellPart)this){

                @NotNull
                public String getCreatorModId(@NotNull ItemStack itemStack) {
                    return "not_enough_glyphs";
                }
            };
        }
        return this.glyphItem;
    }
}

