/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.init;

import alexthw.not_enough_glyphs.common.ContingencyEffect;
import alexthw.not_enough_glyphs.common.spell.MissileProjectile;
import alexthw.not_enough_glyphs.common.spell.TrailingProjectile;
import alexthw.not_enough_glyphs.common.spellbinder.BinderCasterData;
import alexthw.not_enough_glyphs.common.spellbinder.SpellBinder;
import alexthw.not_enough_glyphs.common.spellbinder.SpellBinderContainer;
import alexthw.not_enough_glyphs.init.NotEnoughGlyphs;
import com.hollingsworth.arsnouveau.common.potions.PublicEffect;
import com.hollingsworth.arsnouveau.setup.registry.CreativeTabRegistry;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Registry {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"not_enough_glyphs");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((net.minecraft.core.Registry)BuiltInRegistries.ENTITY_TYPE, (String)"not_enough_glyphs");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((net.minecraft.core.Registry)BuiltInRegistries.MENU, (String)"not_enough_glyphs");
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((net.minecraft.core.Registry)BuiltInRegistries.MOB_EFFECT, (String)"not_enough_glyphs");
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((net.minecraft.core.Registry)BuiltInRegistries.ATTRIBUTE, (String)"not_enough_glyphs");
    public static final Supplier<EntityType<TrailingProjectile>> TRAILING_PROJECTILE;
    public static final Supplier<EntityType<MissileProjectile>> MISSILE_PROJECTILE;
    public static final Supplier<MenuType<SpellBinderContainer>> SPELL_HOLDER;
    public static final Supplier<Item> SPELL_BINDER;
    public static final DeferredHolder<MobEffect, MobEffect> GROWING_EFFECT;
    public static final DeferredHolder<MobEffect, MobEffect> SHRINKING_EFFECT;
    public static final DeferredHolder<MobEffect, MobEffect> CONTINGENCY;
    public static final DeferredRegister<DataComponentType<?>> DATA;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<BinderCasterData>> SPELL_BINDER_CASTER;

    static <T extends Entity> Supplier<EntityType<T>> addEntity(String name, float width, float height, boolean fire, boolean noSave, EntityType.EntityFactory<T> factory, MobCategory kind) {
        return ENTITIES.register(name, () -> {
            EntityType.Builder builder = EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)kind).setTrackingRange(32).sized(width, height);
            if (noSave) {
                builder.noSave();
            }
            if (fire) {
                builder.fireImmune();
            }
            return builder.build("not_enough_glyphs:" + name);
        });
    }

    public static void init(IEventBus modbus) {
        ITEMS.register(modbus);
        ENTITIES.register(modbus);
        CONTAINERS.register(modbus);
        ATTRIBUTES.register(modbus);
        EFFECTS.register(modbus);
        DATA.register(modbus);
        modbus.addListener(event -> {
            if (event.getTab() == CreativeTabRegistry.BLOCKS.get()) {
                for (DeferredHolder item : ITEMS.getEntries()) {
                    event.accept((ItemLike)item.get());
                }
            }
        });
    }

    static {
        GROWING_EFFECT = EFFECTS.register("grow", () -> new PublicEffect(MobEffectCategory.NEUTRAL, 0).addAttributeModifier(Attributes.SCALE, NotEnoughGlyphs.prefix("effects.grow"), 0.5, AttributeModifier.Operation.ADD_VALUE));
        SHRINKING_EFFECT = EFFECTS.register("shrink", () -> new PublicEffect(MobEffectCategory.NEUTRAL, 0).addAttributeModifier(Attributes.SCALE, NotEnoughGlyphs.prefix("effects.shrink"), -0.2, AttributeModifier.Operation.ADD_VALUE));
        CONTINGENCY = EFFECTS.register("contingency", ContingencyEffect::new);
        TRAILING_PROJECTILE = Registry.addEntity("trail", 0.5f, 0.5f, true, true, TrailingProjectile::new, MobCategory.MISC);
        MISSILE_PROJECTILE = Registry.addEntity("missile", 0.75f, 0.75f, true, true, MissileProjectile::new, MobCategory.MISC);
        SPELL_BINDER = ITEMS.register("spell_binder", () -> new SpellBinder(new Item.Properties().stacksTo(1)));
        SPELL_HOLDER = CONTAINERS.register("spell_holder", () -> IMenuTypeExtension.create((id, inv, extraData) -> {
            boolean mainHand = extraData.readBoolean();
            ItemStack stack = inv.player.getItemInHand(mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            return new SpellBinderContainer(id, inv, stack);
        }));
        DATA = DeferredRegister.create((net.minecraft.core.Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"not_enough_glyphs");
        SPELL_BINDER_CASTER = DATA.register("spell_binder_caster", () -> DataComponentType.builder().persistent(BinderCasterData.CODEC.codec()).networkSynchronized(BinderCasterData.STREAM_CODEC).build());
    }
}

