/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.mixins.features;

import com.telepathicgrunt.repurposedstructures.modinit.RSTags;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.SpringFeature;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpringFeature.class})
public class NoFallsInStructuresMixin {
    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void repurposedstructures_noLavaInStructures(FeaturePlaceContext<SpringConfiguration> context, CallbackInfoReturnable<Boolean> cir) {
        block4: {
            BlockPos.MutableBlockPos mutable;
            WorldGenRegion worldGenRegion;
            block3: {
                WorldGenLevel worldGenLevel = context.level();
                if (!(worldGenLevel instanceof WorldGenRegion)) {
                    return;
                }
                worldGenRegion = (WorldGenRegion)worldGenLevel;
                if (!((SpringConfiguration)context.config()).state.is(FluidTags.LAVA)) break block3;
                mutable = new BlockPos.MutableBlockPos();
                for (Direction face : Direction.Plane.HORIZONTAL) {
                    mutable.set((Vec3i)context.origin()).move(face);
                    Registry structureRegistry = (Registry)worldGenRegion.registryAccess().registry(Registries.STRUCTURE).get();
                    List<StructureStart> structureStarts = GeneralUtils.inboundsValidStartsForAllStructure(worldGenRegion, (BlockPos)mutable, struct -> structureRegistry.getHolderOrThrow((ResourceKey)structureRegistry.getResourceKey(struct).get()).is(RSTags.NO_LAVAFALLS));
                    if (structureStarts.isEmpty()) continue;
                    cir.setReturnValue((Object)false);
                    return;
                }
                break block4;
            }
            if (!((SpringConfiguration)context.config()).state.is(FluidTags.WATER)) break block4;
            mutable = new BlockPos.MutableBlockPos();
            for (Direction face : Direction.Plane.HORIZONTAL) {
                mutable.set((Vec3i)context.origin()).move(face);
                Registry structureRegistry = (Registry)worldGenRegion.registryAccess().registry(Registries.STRUCTURE).get();
                List<StructureStart> structureStarts = GeneralUtils.inboundsValidStartsForAllStructure(worldGenRegion, (BlockPos)mutable, struct -> structureRegistry.getHolderOrThrow((ResourceKey)structureRegistry.getResourceKey(struct).get()).is(RSTags.NO_WATERFALLS));
                if (structureStarts.isEmpty()) continue;
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }
}

