/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.configs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class NbtDungeonConfig
implements FeatureConfiguration {
    public static final Codec<NbtDungeonConfig> CODEC = RecordCodecBuilder.create(configInstance -> configInstance.group((App)Codec.BOOL.fieldOf("replace_air").orElse((Object)false).forGetter(nbtDungeonConfig -> nbtDungeonConfig.replaceAir), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("min_air_space").forGetter(nbtFeatureConfig -> nbtFeatureConfig.minAirSpace), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("max_air_space").forGetter(nbtFeatureConfig -> nbtFeatureConfig.maxAirSpace), (App)Codec.intRange((int)0, (int)100).fieldOf("max_num_of_loot_blocks").forGetter(nbtFeatureConfig -> nbtFeatureConfig.maxNumOfChests), (App)Codec.BOOL.fieldOf("air_requirement_is_now_water").orElse((Object)false).forGetter(nbtDungeonConfig -> nbtDungeonConfig.airRequirementIsNowWater), (App)Codec.INT.fieldOf("structure_y_offset").orElse((Object)0).forGetter(nbtFeatureConfig -> nbtFeatureConfig.structureYOffset), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("loot_block").orElse((Object)Blocks.CHEST).forGetter(nbtDungeonConfig -> nbtDungeonConfig.lootBlock), (App)ResourceLocation.CODEC.fieldOf("loot_block_loottable_resourcelocation").forGetter(nbtDungeonConfig -> nbtDungeonConfig.chestResourcelocation), (App)ResourceLocation.CODEC.fieldOf("rs_spawner_resourcelocation").forGetter(nbtDungeonConfig -> nbtDungeonConfig.rsSpawnerResourcelocation), (App)ResourceLocation.CODEC.fieldOf("processors").forGetter(nbtDungeonConfig -> nbtDungeonConfig.processor), (App)ResourceLocation.CODEC.fieldOf("post_processors").orElse((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty")).forGetter(nbtDungeonConfig -> nbtDungeonConfig.postProcessor), (App)Codec.mapPair((MapCodec)ResourceLocation.CODEC.fieldOf("resourcelocation"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("dungeon_nbt_entries").forGetter(nbtFeatureConfig -> nbtFeatureConfig.nbtResourcelocationsAndWeights), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("chance_of_spawning_loot_block_at_spot").forGetter(nbtFeatureConfig -> nbtFeatureConfig.chanceOfSpawningLootBlockAtSpot)).apply((Applicative)configInstance, NbtDungeonConfig::new)).comapFlatMap(nbtDungeonConfig -> nbtDungeonConfig.maxAirSpace <= nbtDungeonConfig.minAirSpace ? DataResult.error(() -> "min_air_space has to be smaller than max_air_space") : DataResult.success((Object)nbtDungeonConfig), Function.identity());
    public final boolean replaceAir;
    public final int minAirSpace;
    public final int maxAirSpace;
    public final int maxNumOfChests;
    public final ResourceLocation chestResourcelocation;
    public final List<Pair<ResourceLocation, Integer>> nbtResourcelocationsAndWeights;
    public final ResourceLocation rsSpawnerResourcelocation;
    public final ResourceLocation processor;
    public final ResourceLocation postProcessor;
    public final boolean airRequirementIsNowWater;
    public final int structureYOffset;
    public final Block lootBlock;
    public final Optional<Float> chanceOfSpawningLootBlockAtSpot;

    public NbtDungeonConfig(boolean replaceAir, int minAirSpace, int maxAirSpace, int maxNumOfChests, boolean airRequirementIsNowWater, int structureYOffset, Block lootBlock, ResourceLocation chestIdentifier, ResourceLocation rsSpawnerIdentifier, ResourceLocation processor, ResourceLocation postProcessor, List<Pair<ResourceLocation, Integer>> nbtIdentifiersAndWeights, Optional<Float> chanceOfSpawningLootBlockAtSpot) {
        this.replaceAir = replaceAir;
        this.minAirSpace = minAirSpace;
        this.maxAirSpace = maxAirSpace;
        this.maxNumOfChests = maxNumOfChests;
        this.chestResourcelocation = chestIdentifier;
        this.nbtResourcelocationsAndWeights = nbtIdentifiersAndWeights;
        this.rsSpawnerResourcelocation = rsSpawnerIdentifier;
        this.processor = processor;
        this.postProcessor = postProcessor;
        this.airRequirementIsNowWater = airRequirementIsNowWater;
        this.structureYOffset = structureYOffset;
        this.lootBlock = lootBlock;
        this.chanceOfSpawningLootBlockAtSpot = chanceOfSpawningLootBlockAtSpot;
    }
}

