/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.neoforge.biomemodifiers;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.neoforge.RSBiomeModifiers;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record AdditionsTemperatureModifier(HolderSet<Biome> biomes, Holder<PlacedFeature> feature, GenerationStep.Decoration step, TEMPERATURE_RANGE temperatureRange) implements BiomeModifier
{
    public static MapCodec<AdditionsTemperatureModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(AdditionsTemperatureModifier::biomes), (App)PlacedFeature.CODEC.fieldOf("feature").forGetter(AdditionsTemperatureModifier::feature), (App)GenerationStep.Decoration.CODEC.fieldOf("step").forGetter(AdditionsTemperatureModifier::step), (App)StringRepresentable.fromEnum(TEMPERATURE_RANGE::values).fieldOf("biome_temperature_allowed").stable().forGetter(AdditionsTemperatureModifier::temperatureRange)).apply((Applicative)builder, AdditionsTemperatureModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome)) {
            String biomeNamespace = ((ResourceKey)biome.unwrapKey().get()).location().getNamespace();
            String biomePath = ((ResourceKey)biome.unwrapKey().get()).location().getPath();
            float biomeTemp = ((Biome)biome.value()).getBaseTemperature();
            switch (this.temperatureRange.ordinal()) {
                case 0: {
                    if ((!GeneralUtils.nameMatch(biomePath, "hot", "tropic", "warm") || GeneralUtils.nameMatch(biomePath, "lukewarm")) && (GeneralUtils.nameExactMatch(biomeNamespace, "minecraft") || !(biomeTemp >= 1.5f))) break;
                    builder.getGenerationSettings().addFeature(this.step, this.feature);
                    break;
                }
                case 1: {
                    if (!GeneralUtils.nameMatch(biomePath, "lukewarm") && (GeneralUtils.nameExactMatch(biomeNamespace, "minecraft") || !(biomeTemp >= 0.9f) || !(biomeTemp < 1.5f))) break;
                    builder.getGenerationSettings().addFeature(this.step, this.feature);
                    break;
                }
                case 2: {
                    if (GeneralUtils.nameMatch(biomePath, "hot", "tropic", "warm", "cold", "chilly", "frozen", "snow", "ice", "frost") && (GeneralUtils.nameExactMatch(biomeNamespace, "minecraft") || !(biomeTemp >= 0.5f) || !(biomeTemp < 0.9f))) break;
                    builder.getGenerationSettings().addFeature(this.step, this.feature);
                    break;
                }
                case 3: {
                    if (!GeneralUtils.nameMatch(biomePath, "cold", "chilly") && (GeneralUtils.nameExactMatch(biomeNamespace, "minecraft") || !(biomeTemp >= 0.0f) || !(biomeTemp < 0.5f))) break;
                    builder.getGenerationSettings().addFeature(this.step, this.feature);
                    break;
                }
                case 4: {
                    if (!GeneralUtils.nameMatch(biomePath, "frozen", "snow", "ice", "frost") && (GeneralUtils.nameExactMatch(biomeNamespace, "minecraft") || !(biomeTemp < 0.0f))) break;
                    builder.getGenerationSettings().addFeature(this.step, this.feature);
                }
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)RSBiomeModifiers.ADDITIONS_TEMPERATURE_MODIFIER.get();
    }

    public static enum TEMPERATURE_RANGE implements StringRepresentable
    {
        WARM("WARM"),
        LUKEWARM("LUKEWARM"),
        NEUTRAL("NEUTRAL"),
        COLD("COLD"),
        FROZEN("FROZEN");

        private final String name;
        private static final Map<String, TEMPERATURE_RANGE> BY_NAME;

        private TEMPERATURE_RANGE(String name) {
            this.name = name;
        }

        public static TEMPERATURE_RANGE byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_NAME = (Map)Util.make((Object)Maps.newHashMap(), hashMap -> {
                TEMPERATURE_RANGE[] var1;
                for (TEMPERATURE_RANGE type : var1 = TEMPERATURE_RANGE.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

