/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSPredicates;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;

public class YValuePosRuleTest
extends PosRuleTest {
    public static final MapCodec<YValuePosRuleTest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("min_y_value").forGetter(ruleTest -> ruleTest.minYValue), (App)Codec.INT.fieldOf("max_y_value").forGetter(ruleTest -> ruleTest.maxYValue)).apply((Applicative)instance, YValuePosRuleTest::new));
    private final int minYValue;
    private final int maxYValue;

    public YValuePosRuleTest(int minYValue, int maxYValue) {
        if (minYValue > maxYValue) {
            throw new IllegalArgumentException("Invalid range: [" + minYValue + "," + maxYValue + "]");
        }
        this.minYValue = minYValue;
        this.maxYValue = maxYValue;
    }

    public boolean test(BlockPos blockPos, BlockPos blockPos2, BlockPos blockPos3, RandomSource random) {
        return blockPos2.getY() >= this.minYValue && blockPos2.getY() <= this.maxYValue;
    }

    protected PosRuleTestType<?> getType() {
        return RSPredicates.Y_VALUE_POS_RULE_TEST.get();
    }
}

