/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking;

import com.mamailes.merrymaking.config.MerryMakingConfig;
import com.mamailes.merrymaking.entity.client.ChristmasCreeperRenderer;
import com.mamailes.merrymaking.init.MMArmorMaterial;
import com.mamailes.merrymaking.init.MMBlocks;
import com.mamailes.merrymaking.init.MMCreativeTabs;
import com.mamailes.merrymaking.init.MMEntities;
import com.mamailes.merrymaking.init.MMItems;
import com.mamailes.merrymaking.init.MMLootModifiers;
import com.mamailes.merrymaking.init.MMSounds;
import com.mojang.logging.LogUtils;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="merrymaking")
public class MerryMaking {
    public static final String MODID = "merrymaking";
    private static final String MODEL_DIR = "textures/entity/";
    public static final Logger LOGGER = LogUtils.getLogger();

    public MerryMaking(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)MerryMakingConfig.SPEC, "merrymaking-common.toml");
        modEventBus.addListener(this::commonSetup);
        MMBlocks.BLOCKS.register(modEventBus);
        MMItems.ITEMS.register(modEventBus);
        MMCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        MMSounds.register(modEventBus);
        MMArmorMaterial.ARMOR_MATERIALS.register(modEventBus);
        MMLootModifiers.LOOT_MODIFIERS.register(modEventBus);
        MMEntities.ENTITIES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    public static ResourceLocation getModelTexture(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)(MODEL_DIR + name));
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }

    @EventBusSubscriber(modid="merrymaking", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
            EntityRenderers.register(MMEntities.CHRISTMAS_CREEPER.get(), ChristmasCreeperRenderer::new);
        }
    }
}

