/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.tools.common.config.MekanismToolsConfig;
import mekanism.tools.common.config.ToolsConfigTranslations;
import mekanism.tools.common.material.MaterialCreator;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ToolsConfig
extends BaseMekanismConfig {
    private final ModConfigSpec configSpec;
    public final CachedFloatValue armorSpawnChance;
    public final CachedFloatValue weaponSpawnChance;
    public final CachedFloatValue weaponSpawnChanceHard;
    public final ArmorSpawnChanceConfig bronzeSpawnRate;
    public final ArmorSpawnChanceConfig lapisLazuliSpawnRate;
    public final ArmorSpawnChanceConfig osmiumSpawnRate;
    public final ArmorSpawnChanceConfig refinedGlowstoneSpawnRate;
    public final ArmorSpawnChanceConfig refinedObsidianSpawnRate;
    public final ArmorSpawnChanceConfig steelSpawnRate;

    ToolsConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        ToolsConfigTranslations.SERVER_GEAR_SPAWN_CHANCE.applyToBuilder(builder).push("mobGearSpawnRate");
        this.armorSpawnChance = CachedFloatValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)ToolsConfigTranslations.SERVER_GEAR_SPAWN_CHANCE_ARMOR.applyToBuilder(builder).defineInRange("general", 0.1, 0.0, 1.0));
        this.weaponSpawnChance = CachedFloatValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)ToolsConfigTranslations.SERVER_GEAR_SPAWN_CHANCE_WEAPON.applyToBuilder(builder).defineInRange("weapon", 0.01, 0.0, 1.0));
        this.weaponSpawnChanceHard = CachedFloatValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)ToolsConfigTranslations.SERVER_GEAR_SPAWN_CHANCE_WEAPON_HARD.applyToBuilder(builder).defineInRange("weaponHard", (double)0.05f, 0.0, 1.0));
        this.bronzeSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, MekanismToolsConfig.materials.bronze);
        this.lapisLazuliSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, MekanismToolsConfig.materials.lapisLazuli);
        this.osmiumSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, MekanismToolsConfig.materials.osmium);
        this.refinedGlowstoneSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, MekanismToolsConfig.materials.refinedGlowstone);
        this.refinedObsidianSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, MekanismToolsConfig.materials.refinedObsidian);
        this.steelSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, MekanismToolsConfig.materials.steel);
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "tools";
    }

    public String getTranslation() {
        return "General Config";
    }

    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public static class ArmorSpawnChanceConfig {
        public final CachedBooleanValue canSpawnWeapon;
        public final CachedFloatValue swordWeight;
        public final CachedFloatValue helmetChance;
        public final CachedFloatValue chestplateChance;
        public final CachedFloatValue leggingsChance;
        public final CachedFloatValue bootsChance;
        public final CachedFloatValue multiplePieceChance;
        public final CachedFloatValue multiplePieceChanceHard;
        public final CachedFloatValue weaponEnchantmentChance;
        public final CachedFloatValue armorEnchantmentChance;

        private ArmorSpawnChanceConfig(IMekanismConfig config, ModConfigSpec.Builder builder, MaterialCreator material) {
            this(config, builder, material.getRegistryPrefix(), 0.33, 1.0, 1.0, 1.0, 1.0, 0.25, 0.5);
        }

        private ArmorSpawnChanceConfig(IMekanismConfig config, ModConfigSpec.Builder builder, String key, double swordChance, double helmetChance, double chestplateChance, double leggingsChance, double bootsChance, double weaponEnchantmentChance, double armorEnchantmentChance) {
            ToolsConfigTranslations.ArmorSpawnChanceTranslations translations = ToolsConfigTranslations.ArmorSpawnChanceTranslations.create(key);
            translations.topLevel().applyToBuilder(builder).push(key);
            this.canSpawnWeapon = CachedBooleanValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.canSpawnWeapon().applyToBuilder(builder).define("canSpawnWeapon", true));
            this.swordWeight = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.swordWeight().applyToBuilder(builder).defineInRange("swordWeight", swordChance, 0.0, 1.0));
            this.helmetChance = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.helmetChance().applyToBuilder(builder).defineInRange("helmetChance", helmetChance, 0.0, 1.0));
            this.chestplateChance = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.chestplateChance().applyToBuilder(builder).defineInRange("chestplateChance", chestplateChance, 0.0, 1.0));
            this.leggingsChance = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.leggingsChance().applyToBuilder(builder).defineInRange("leggingsChance", leggingsChance, 0.0, 1.0));
            this.bootsChance = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.bootsChance().applyToBuilder(builder).defineInRange("bootsChance", bootsChance, 0.0, 1.0));
            this.multiplePieceChance = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.multiplePieceChance().applyToBuilder(builder).defineInRange("multiplePieceChance", 0.25, 0.0, 1.0));
            this.multiplePieceChanceHard = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.multiplePieceChanceHard().applyToBuilder(builder).defineInRange("multiplePieceChanceHard", 0.1, 0.0, 1.0));
            this.weaponEnchantmentChance = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.weaponEnchantmentChance().applyToBuilder(builder).defineInRange("weaponEnchantmentChance", weaponEnchantmentChance, 0.0, 1.0));
            this.armorEnchantmentChance = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.armorEnchantmentChance().applyToBuilder(builder).defineInRange("armorEnchantmentChance", armorEnchantmentChance, 0.0, 1.0));
            builder.pop();
        }
    }
}

