/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material;

import java.util.List;
import mekanism.tools.common.ToolsTags;
import mekanism.tools.common.material.IPaxelMaterial;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public interface BaseMekanismMaterial
extends Tier,
IPaxelMaterial {
    public int getShieldDurability();

    default public float getSwordDamage() {
        return 3.0f;
    }

    default public float getSwordAtkSpeed() {
        return -2.4f;
    }

    default public float getShovelDamage() {
        return 1.5f;
    }

    default public float getShovelAtkSpeed() {
        return -3.0f;
    }

    public float getAxeDamage();

    public float getAxeAtkSpeed();

    default public float getPickaxeDamage() {
        return 1.0f;
    }

    default public float getPickaxeAtkSpeed() {
        return -2.8f;
    }

    default public float getHoeDamage() {
        return -this.getAttackDamageBonus();
    }

    default public float getHoeAtkSpeed() {
        return this.getAttackDamageBonus() - 3.0f;
    }

    @Override
    default public float getPaxelDamage() {
        return this.getAxeDamage() + 1.0f;
    }

    @Override
    default public int getPaxelDurability() {
        return 2 * this.getUses();
    }

    @Override
    default public float getPaxelEfficiency() {
        return this.getSpeed();
    }

    @Override
    default public int getPaxelEnchantability() {
        return this.getEnchantmentValue();
    }

    public String getRegistryPrefix();

    default public boolean burnsInFire() {
        return true;
    }

    public float toughness();

    public float knockbackResistance();

    public Holder<SoundEvent> equipSound();

    public int getDefense(ArmorItem.Type var1);

    public int getDurabilityForType(ArmorItem.Type var1);

    default public Tool createToolProperties(@NotNull TagKey<Block> block) {
        float speed = block == ToolsTags.Blocks.MINEABLE_WITH_PAXEL ? this.getPaxelEfficiency() : this.getSpeed();
        return new Tool(List.of(Tool.Rule.deniesDrops((TagKey)this.getIncorrectBlocksForDrops()), Tool.Rule.minesAndDrops(block, (float)speed)), 1.0f, 1);
    }
}

