/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.builder;

import aztech.modern_industrialization.machines.models.MachineCasing;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.compat.mi.hack.HackedMachineRegistrationHelper;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHook;

public class MachineBuiltinModelBuilder {
    private final MachineCasing casing;
    private final String overlayFolder;
    private boolean front;
    private boolean top;
    private boolean side;
    private boolean active;

    MachineBuiltinModelBuilder(MachineCasing casing, String overlayFolder) {
        Assert.noneNull(overlayFolder);
        this.casing = casing;
        this.overlayFolder = overlayFolder;
    }

    public MachineBuiltinModelBuilder front(boolean front) {
        this.front = front;
        return this;
    }

    public MachineBuiltinModelBuilder front() {
        return this.front(true);
    }

    public MachineBuiltinModelBuilder top(boolean top) {
        this.top = top;
        return this;
    }

    public MachineBuiltinModelBuilder top() {
        return this.top(true);
    }

    public MachineBuiltinModelBuilder side(boolean side) {
        this.side = side;
        return this;
    }

    public MachineBuiltinModelBuilder side() {
        return this.side(true);
    }

    public MachineBuiltinModelBuilder active(boolean active) {
        this.active = active;
        return this;
    }

    public MachineBuiltinModelBuilder active() {
        return this.active(true);
    }

    void build(MIHook hook, String id, MachineCasing casing) {
        Assert.notNull((Object)casing, "Machine casing must be provided");
        HackedMachineRegistrationHelper.addMachineModel(hook, id, casing, this.overlayFolder, this.front, this.top, this.side, this.active);
    }

    void build(MIHook hook, String id) {
        this.build(hook, id, this.casing);
    }
}

