/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.builder;

import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.compat.rei.machines.SteamMode;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.RecipeEfficiencyBar;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.compat.mi.hack.HackedMachineRegistrationHelper;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHook;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineRecipePredicate;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.slots.MachineSlotConfiguration;

public final class MachineGuiConfiguration {
    private final boolean isMultiblock;
    private final SteamMode steamMode;
    private final MachineRecipeType recipeType;
    private int guiHeight = 166;
    private boolean lockButton = true;
    private final MachineSlotConfiguration.Builder inventoryOnlySlots = new MachineSlotConfiguration.Builder();
    private final MachineSlotConfiguration.Builder slots = new MachineSlotConfiguration.Builder();
    private ProgressBar.Parameters progressBar;
    private EnergyBar.Parameters energyBar;
    private RecipeEfficiencyBar.Parameters efficiencyBar;
    private MachineRecipePredicate predicate = recipe -> true;

    MachineGuiConfiguration(boolean isMultiblock, SteamMode steamMode, MachineRecipeType recipeType) {
        this.isMultiblock = isMultiblock;
        this.steamMode = steamMode;
        this.recipeType = recipeType;
    }

    public MachineGuiConfiguration copy() {
        MachineGuiConfiguration copy = new MachineGuiConfiguration(this.isMultiblock, this.steamMode, this.recipeType);
        copy.guiHeight = this.guiHeight;
        copy.lockButton = this.lockButton;
        copy.inventoryOnlySlots.append(this.inventoryOnlySlots);
        copy.slots.append(this.slots);
        copy.progressBar = this.progressBar;
        copy.energyBar = this.energyBar;
        copy.efficiencyBar = this.efficiencyBar;
        copy.predicate = this.predicate;
        return copy;
    }

    public boolean isMultiblock() {
        return this.isMultiblock;
    }

    public SteamMode getSteamMode() {
        return this.steamMode;
    }

    public MachineRecipeType getRecipeType() {
        return this.recipeType;
    }

    public int getGuiHeight() {
        return this.guiHeight;
    }

    public boolean hasLockButton() {
        return this.lockButton;
    }

    public MachineSlotConfiguration getInventoryOnlySlots() {
        return this.inventoryOnlySlots.build();
    }

    public MachineSlotConfiguration getSlots() {
        return this.slots.build();
    }

    public ProgressBar.Parameters getProgressBar() {
        return this.progressBar;
    }

    public EnergyBar.Parameters getEnergyBar() {
        return this.energyBar;
    }

    public RecipeEfficiencyBar.Parameters getEfficiencyBar() {
        return this.efficiencyBar;
    }

    public MachineRecipePredicate getPredicate() {
        return this.predicate;
    }

    public MachineGuiConfiguration guiHeight(int guiHeight) {
        this.guiHeight = guiHeight;
        return this;
    }

    public MachineGuiConfiguration lockButton(boolean lockButton) {
        this.lockButton = lockButton;
        return this;
    }

    public MachineGuiConfiguration inventoryOnlySlots(Consumer<MachineSlotConfiguration.Builder> builder) {
        builder.accept(this.inventoryOnlySlots);
        return this;
    }

    public MachineGuiConfiguration slots(Consumer<MachineSlotConfiguration.Builder> builder) {
        builder.accept(this.slots);
        return this;
    }

    public MachineGuiConfiguration progressBar(int renderX, int renderY, String progressBarType, boolean isVertical) {
        this.progressBar = new ProgressBar.Parameters(renderX, renderY, progressBarType, isVertical);
        return this;
    }

    public MachineGuiConfiguration progressBar(int renderX, int renderY, String progressBarType) {
        return this.progressBar(renderX, renderY, progressBarType, false);
    }

    public MachineGuiConfiguration energyBar(int renderX, int renderY) {
        this.energyBar = new EnergyBar.Parameters(renderX, renderY);
        return this;
    }

    public MachineGuiConfiguration efficiencyBar(int renderX, int renderY) {
        this.efficiencyBar = new RecipeEfficiencyBar.Parameters(renderX, renderY);
        return this;
    }

    public MachineGuiConfiguration predicate(MachineRecipePredicate predicate) {
        Assert.notNull(predicate);
        this.predicate = predicate;
        return this;
    }

    public MachineGuiParameters createGuiParams(ResourceLocation blockId) {
        return new MachineGuiParameters.Builder(blockId, this.lockButton).backgroundHeight(this.guiHeight).build();
    }

    public MachineInventoryComponent buildInventory() {
        return MachineSlotConfiguration.combine(this.inventoryOnlySlots.build(), this.slots.build()).build().toInventoryComponent();
    }

    public void registerProgressBar(MachineBlockEntity machine, Supplier<Float> progress) {
        Assert.noneNull(machine, progress);
        if (this.progressBar != null) {
            machine.guiComponents.register((Object[])new GuiComponent.Server[]{new ProgressBar.Server(this.progressBar, progress)});
        }
    }

    public void registerEnergyBar(MachineBlockEntity machine, Supplier<Long> euSupplier, Supplier<Long> maxEuSupplier) {
        Assert.noneNull(machine, euSupplier, maxEuSupplier);
        if (this.energyBar != null) {
            machine.guiComponents.register((Object[])new GuiComponent.Server[]{new EnergyBar.Server(this.energyBar, euSupplier, maxEuSupplier)});
        }
    }

    public void registerEfficiencyBar(MachineBlockEntity machine, CrafterComponent crafter) {
        Assert.noneNull(machine, crafter);
        if (this.efficiencyBar != null) {
            machine.guiComponents.register((Object[])new GuiComponent.Server[]{new RecipeEfficiencyBar.Server(this.efficiencyBar, crafter)});
        }
    }

    boolean hasRecipeCategory() {
        return this.recipeType != null;
    }

    void registerRecipeCategory(MIHook hook, String name, String englishName, int tiers) {
        Assert.notNull((Object)this.recipeType, "Recipe type must be provided");
        Assert.notNull((Object)this.progressBar, "Progress bar must be configured");
        MachineSlotConfiguration.AllSlotPositions slotPositions = this.slots.build().toSlotPositions();
        Assert.that(slotPositions.hasInputs() && slotPositions.hasOutputs(), "At least one input and one output slot must be provided");
        HackedMachineRegistrationHelper.registerReiTiers(hook, englishName, name, this.recipeType, new MachineCategoryParams(null, null, slotPositions.itemInputs(), slotPositions.itemOutputs(), slotPositions.fluidInputs(), slotPositions.fluidOutputs(), this.progressBar, null, null, false, null), tiers);
    }

    void registerRecipeCategory(MIHook hook, String name, String englishName) {
        Assert.notNull((Object)this.recipeType, "Recipe type must be provided");
        Assert.notNull((Object)this.progressBar, "Progress bar must be configured");
        MachineSlotConfiguration.AllSlotPositions slotPositions = this.slots.build().toSlotPositions();
        Assert.that(slotPositions.hasInputs() && slotPositions.hasOutputs(), "At least one input and one output slot must be provided");
        HackedMachineRegistrationHelper.registerRecipeCategory(hook, name, englishName, this.recipeType, slotPositions.itemInputs(), slotPositions.itemOutputs(), slotPositions.fluidInputs(), slotPositions.fluidOutputs(), this.progressBar, recipe -> this.predicate.test((MachineRecipe)recipe), this.isMultiblock, this.steamMode);
    }
}

