/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.vanilla.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.swedz.tesseract.neoforge.helper.RecipeHelper;
import net.swedz.tesseract.neoforge.recipe.RecipeBuilder;

public class ShapedRecipeBuilder
extends RecipeBuilder {
    protected final Map<Character, Ingredient> key = Maps.newHashMap();
    protected final List<String> pattern = Lists.newArrayList();

    public Map<Character, Ingredient> key() {
        return Collections.unmodifiableMap(this.key);
    }

    public List<String> pattern() {
        return Collections.unmodifiableList(this.pattern);
    }

    public ShapedRecipeBuilder define(char key, Ingredient ingredient) {
        if (ingredient == null || ingredient == Ingredient.EMPTY) {
            throw new NullPointerException("Input ingredient cannot be null or empty");
        }
        if (this.key.put(Character.valueOf(key), ingredient) != null) {
            throw new IllegalStateException("Key mapping is already registered: " + key);
        }
        return this;
    }

    public ShapedRecipeBuilder define(char key, ItemLike ... items) {
        return this.define(key, Ingredient.of((ItemLike[])items));
    }

    public ShapedRecipeBuilder define(char key, ItemStack ... stacks) {
        return this.define(key, Ingredient.of((ItemStack[])stacks));
    }

    public ShapedRecipeBuilder define(char key, TagKey<Item> tag) {
        return this.define(key, Ingredient.of(tag));
    }

    public ShapedRecipeBuilder define(char key, ResourceLocation ... itemIds) {
        return this.define(key, RecipeHelper.ingredient(itemIds));
    }

    public ShapedRecipeBuilder define(char key, String maybeTag) {
        return this.define(key, RecipeHelper.ingredient(maybeTag));
    }

    public ShapedRecipeBuilder pattern(String line) {
        if (line == null) {
            throw new NullPointerException("Pattern cannot be null");
        }
        this.pattern.add(line);
        return this;
    }

    @Override
    public void validate() {
        if (this.pattern.isEmpty() || this.pattern.size() > 3) {
            throw new IllegalArgumentException("Invalid length " + this.pattern.size());
        }
        for (String string : this.pattern) {
            if (string.length() == this.pattern.getFirst().length()) continue;
            throw new IllegalArgumentException("Pattern length mismatch: " + string.length() + ", expected " + this.pattern.getFirst().length());
        }
        for (String string : this.pattern) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == ' ' || this.key.containsKey(Character.valueOf(string.charAt(i)))) continue;
                throw new IllegalArgumentException("Key " + string.charAt(i) + " is missing a mapping.");
            }
        }
        Iterator<Object> iterator = this.key.keySet().iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            boolean ok = false;
            block4: for (String string : this.pattern) {
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != c) continue;
                    ok = true;
                    continue block4;
                }
            }
            if (ok) continue;
            throw new IllegalArgumentException("Key mapping '" + c + "' is not used in the pattern.");
        }
    }

    @Override
    public Recipe<?> convert() {
        return new ShapedRecipe("", CraftingBookCategory.MISC, ShapedRecipePattern.of(this.key, this.pattern), this.result);
    }

    @Override
    public ShapedRecipeBuilder output(ItemLike result, int count) {
        super.output(result, count);
        return this;
    }

    @Override
    public ShapedRecipeBuilder output(String result, int count) {
        super.output(result, count);
        return this;
    }
}

