/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.tooltip;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.swedz.tesseract.neoforge.Tesseract;
import net.swedz.tesseract.neoforge.compat.mi.proxy.TesseractMIProxy;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import net.swedz.tesseract.neoforge.proxy.builtin.TesseractProxy;
import net.swedz.tesseract.neoforge.tooltip.TooltipAttachment;

public final class TooltipHandler {
    private static final ConcurrentLinkedQueue<TooltipAttachment> TOOLTIPS = new ConcurrentLinkedQueue();

    static void register(TooltipAttachment tooltip) {
        TOOLTIPS.add(tooltip);
    }

    public static void attach(TooltipFlag flags, Item.TooltipContext context, ItemStack stack, List<Component> lines) {
        block3: {
            Item item = stack.getItem();
            if (item == null) break block3;
            boolean hasPrintRequiredShift = false;
            for (TooltipAttachment tooltip : TOOLTIPS) {
                Optional<List<? extends Component>> maybeComponents;
                block5: {
                    block4: {
                        maybeComponents = tooltip.lines(flags, context, stack);
                        if (!tooltip.requiresShift()) break block4;
                        if (!Proxies.get(TesseractProxy.class).hasShiftDown()) break block5;
                    }
                    maybeComponents.ifPresent(lines::addAll);
                    continue;
                }
                if (!tooltip.requiresShift() || hasPrintRequiredShift || !maybeComponents.isPresent()) continue;
                hasPrintRequiredShift = true;
                if (Proxies.get(TesseractMIProxy.class).anyShiftTooltipsAreFor(stack, item)) continue;
                lines.add((Component)Tesseract.text().tooltipsShiftRequired());
            }
        }
    }
}

