/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage;

import aztech.modern_industrialization.blocks.storage.AbstractStorageBlockEntity;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StorageUtil;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class AbstractStorageBlock<T extends TransferVariant<?>>
extends Block
implements EntityBlock {
    public final EntityBlock factory;
    public final StorageBehaviour<T> behavior;

    public AbstractStorageBlock(BlockBehaviour.Properties settings, EntityBlock factory, StorageBehaviour<T> behaviour) {
        super(settings);
        this.factory = factory;
        this.behavior = behaviour;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.factory.newBlockEntity(pos, state);
    }

    protected ItemStack getStack(BlockEntity entity) {
        AbstractStorageBlockEntity storageBlockEntity = (AbstractStorageBlockEntity)entity;
        ItemStack stack = new ItemStack((ItemLike)this.asItem());
        if (storageBlockEntity != null && (!storageBlockEntity.isEmpty() || storageBlockEntity.isLocked())) {
            storageBlockEntity.saveToItem(stack, (HolderLookup.Provider)storageBlockEntity.getLevel().registryAccess());
        }
        return stack;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return List.of(this.getStack((BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)));
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return this.getStack(world.getBlockEntity(pos));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return !this.behavior.isCreative();
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractStorageBlockEntity) {
            AbstractStorageBlockEntity storageBlockEntity = (AbstractStorageBlockEntity)blockEntity;
            return StorageUtil.calculateComparatorOutput(storageBlockEntity);
        }
        return 0;
    }
}

