/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.barrel;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.blocks.storage.AbstractStorageBlockItem;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlock;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelTooltipData;
import aztech.modern_industrialization.items.ItemContainingItemHelper;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.TextHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class BarrelItem
extends AbstractStorageBlockItem<ItemVariant>
implements ItemContainingItemHelper {
    private static final int ITEM_BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);

    public BarrelItem(BarrelBlock block, Item.Properties settings) {
        super(block, settings.stacksTo(1));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        StorageBehaviour storageBehaviour = this.behaviour;
        if (storageBehaviour instanceof BarrelBlock.BarrelStorage) {
            BarrelBlock.BarrelStorage barrelStorage = (BarrelBlock.BarrelStorage)storageBehaviour;
            Style style = Style.EMPTY.withColor(TextColor.fromRgb((int)0xA9A9A9)).withItalic(Boolean.valueOf(false));
            if (this.isEmpty(stack) && this.isUnlocked(stack)) {
                tooltip.add((Component)MIText.Empty.text().setStyle(style));
                tooltip.add((Component)MIText.BarrelStack.text(barrelStorage.stackCapacity).setStyle(TextHelper.YELLOW));
            }
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public long getCurrentCapacity(ItemStack stack) {
        return this.behaviour.getCapacityForResource((ItemVariant)this.getResource(stack));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (!this.getBehaviour().isCreative()) {
            if (!this.isEmpty(stack) || !this.isUnlocked(stack)) {
                return Optional.of(new BarrelTooltipData((ItemVariant)this.getResource(stack), this.getAmount(stack), this.getCurrentCapacity(stack), false));
            }
        } else if (!((ItemVariant)this.getResource(stack)).isBlank()) {
            return Optional.of(new BarrelTooltipData((ItemVariant)this.getResource(stack), -1L, -1L, true));
        }
        return Optional.empty();
    }

    public boolean isBarVisible(ItemStack stack) {
        return !this.getBehaviour().isCreative() && this.getAmount(stack) > 0L;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.min(1L + 12L * this.getAmount(stack) / this.getCurrentCapacity(stack), 13L);
    }

    public int getBarColor(ItemStack stack) {
        return ITEM_BAR_COLOR;
    }

    public boolean overrideStackedOnOther(ItemStack stackBarrel, Slot slot, ClickAction clickType, Player player) {
        return this.handleStackedOnOther(stackBarrel, slot, clickType, player);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        return this.handleOtherStackedOnMe(stack, otherStack, slot, clickType, player, cursorStackReference);
    }
}

