/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.recipe;

import aztech.modern_industrialization.machines.recipe.condition.AdjacentBlockProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.BiomeProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.CustomProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.DimensionProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessConditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public interface ProcessConditionHelper {
    public ProcessConditionHelper processCondition(MachineProcessCondition var1);

    default public ProcessConditionHelper dimension(ResourceLocation dimension) {
        return this.processCondition(new DimensionProcessCondition((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension)));
    }

    default public ProcessConditionHelper adjacentBlock(Block block, String relativePosition) {
        return this.processCondition(new AdjacentBlockProcessCondition(block, relativePosition));
    }

    default public ProcessConditionHelper biome(ResourceLocation biome) {
        return this.processCondition(new BiomeProcessCondition((Either<ResourceKey<Biome>, TagKey<Biome>>)Either.left((Object)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biome))));
    }

    default public ProcessConditionHelper biomeTag(ResourceLocation tag) {
        return this.processCondition(new BiomeProcessCondition((Either<ResourceKey<Biome>, TagKey<Biome>>)Either.right((Object)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tag))));
    }

    default public ProcessConditionHelper customCondition(String id) {
        return this.processCondition(new CustomProcessCondition(id));
    }

    default public ProcessConditionHelper registeredCondition(JsonElement condition) {
        if (!condition.isJsonObject()) {
            throw new IllegalArgumentException("Parameter must be a JsonObject");
        }
        JsonObject obj = condition.getAsJsonObject();
        if (obj.size() != 1) {
            throw new IllegalArgumentException("Expected only condition ID");
        }
        Map.Entry entry = (Map.Entry)obj.entrySet().iterator().next();
        String idString = (String)entry.getKey();
        ResourceLocation id = ResourceLocation.tryParse((String)idString);
        if (id == null) {
            throw new IllegalArgumentException(String.format("'%s' is not registered at MachineProcessConditions. Perhaps you meant to use a customCondition?", idString));
        }
        MapCodec<? extends MachineProcessCondition> codec = MachineProcessConditions.getCodec(id);
        if (codec == null) {
            throw new IllegalArgumentException("'%s' doesn't have a registered codec!".formatted(idString));
        }
        DataResult result = codec.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).map(Pair::getFirst);
        return this.processCondition((MachineProcessCondition)result.getOrThrow(p -> {
            throw new IllegalArgumentException("Couldn't parse '%s': %s".formatted(idString, p));
        }));
    }
}

