/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.usage;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.machines.guicomponents.NuclearReactorGuiClient;
import aztech.modern_industrialization.nuclear.FluidNuclearComponent;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.NeutronInteraction;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.nuclear.NuclearComponentItem;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.util.TextHelper;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class NeutronInteractionCategory
extends ViewerCategory<Recipe> {
    public static final ResourceLocation TEXTURE_ATLAS = NuclearReactorGuiClient.TEXTURE_ATLAS;
    private static final ResourceLocation PROGRESS_BAR = MI.id("textures/gui/progress_bar/long_arrow.png");
    private final int centerX;
    private final int centerY;

    public NeutronInteractionCategory() {
        super(Recipe.class, MI.id("neutron_interaction"), (Component)MIText.NeutronInteraction.text(), ((Item)BuiltInRegistries.ITEM.get(MI.id("uranium_fuel_rod"))).getDefaultInstance(), 150, 90);
        this.centerX = this.width / 2;
        this.centerY = this.height / 2 - 5;
    }

    @Override
    public void buildWorkstations(ViewerCategory.WorkstationConsumer consumer) {
        consumer.accept("nuclear_reactor");
    }

    @Override
    public void buildRecipes(RecipeManager recipeManager, RegistryAccess registryAccess, Consumer<Recipe> consumer) {
        BuiltInRegistries.ITEM.stream().filter(item -> item instanceof NuclearComponentItem).forEach(item -> {
            ItemVariant product;
            NuclearComponentItem component = (NuclearComponentItem)item;
            if (component.neutronBehaviour != INeutronBehaviour.NO_INTERACTION) {
                consumer.accept(new Recipe(component, CategoryType.FAST_NEUTRON_INTERACTION));
                consumer.accept(new Recipe(component, CategoryType.THERMAL_NEUTRON_INTERACTION));
            }
            if (item instanceof NuclearFuel) {
                consumer.accept(new Recipe(component, CategoryType.FISSION));
            }
            if ((product = (ItemVariant)component.getNeutronProduct()) != null) {
                consumer.accept(new Recipe(component, CategoryType.NEUTRON_PRODUCT));
            }
        });
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            FluidNuclearComponent component;
            if (!fluid.isSource(fluid.defaultFluidState()) || fluid == Fluids.EMPTY || (component = FluidNuclearComponent.get(fluid)) == null) continue;
            consumer.accept(new Recipe(component, CategoryType.FAST_NEUTRON_INTERACTION));
            consumer.accept(new Recipe(component, CategoryType.THERMAL_NEUTRON_INTERACTION));
            if (component.getVariant() == null) continue;
            consumer.accept(new Recipe(component, CategoryType.NEUTRON_PRODUCT));
        }
    }

    @Override
    public void buildLayout(Recipe recipe, ViewerCategory.LayoutBuilder builder) {
        switch (recipe.type.ordinal()) {
            case 2: {
                builder.inputSlot(52, this.centerY).variant((TransferVariant<?>)recipe.nuclearComponent.getVariant());
                break;
            }
            case 3: {
                Object product;
                long amount = recipe.nuclearComponent.getNeutronProductAmount();
                int baseX = 66;
                Object obj = recipe.nuclearComponent.getVariant();
                if (obj instanceof ItemVariant) {
                    ItemVariant itemVariant = (ItemVariant)obj;
                    builder.inputSlot(baseX - 35, this.centerY).item(itemVariant.toStack());
                    product = (ItemVariant)recipe.nuclearComponent.getNeutronProduct();
                    builder.outputSlot(baseX + 35, this.centerY).item(product.toStack((int)amount));
                    break;
                }
                product = recipe.nuclearComponent.getVariant();
                if (!(product instanceof FluidVariant)) break;
                FluidVariant fluidVariant = (FluidVariant)product;
                float probability = (float)recipe.nuclearComponent.getNeutronProductProbability();
                builder.inputSlot(baseX - 35, this.centerY).fluid(fluidVariant, 1L, probability);
                FluidVariant product2 = (FluidVariant)recipe.nuclearComponent.getNeutronProduct();
                builder.outputSlot(baseX + 35, this.centerY).fluid(product2, amount, probability);
                break;
            }
            case 0: 
            case 1: {
                builder.inputSlot(66, this.centerY).variant((TransferVariant<?>)recipe.nuclearComponent.getVariant());
            }
        }
    }

    @Override
    public void buildWidgets(Recipe recipe, ViewerCategory.WidgetList widgets) {
        switch (recipe.type.ordinal()) {
            case 2: {
                int centerX = 52;
                NuclearFuel fuel = (NuclearFuel)recipe.nuclearComponent;
                widgets.text((Component)MIText.SingleNeutronCapture.text(), this.centerX, this.centerY - 34, ViewerCategory.TextAlign.CENTER, false, true, null);
                widgets.texture(TEXTURE_ATLAS, centerX - 28, this.centerY - 7, 0, 109, 92, 31);
                widgets.text((Component)MIText.NeutronsMultiplication.text(String.format("%.1f", fuel.neutronMultiplicationFactor)).setStyle(TextHelper.NEUTRONS), this.centerX, this.centerY + 35, ViewerCategory.TextAlign.CENTER, false, true, (Component)MIText.NeutronTemperatureVariation.text());
                widgets.text((Component)Component.literal((String)String.format("%d EU", 8)).setStyle(TextHelper.NEUTRONS), centerX - 18, this.centerY + 23, ViewerCategory.TextAlign.CENTER, false, false, (Component)MIText.FastNeutronEnergy.text());
                widgets.text((Component)Component.literal((String)String.format("%d EU", fuel.directEUbyDesintegration)), centerX + 55, this.centerY + 23, ViewerCategory.TextAlign.CENTER, false, true, (Component)MIText.DirectEnergy.text());
                widgets.text((Component)Component.literal((String)String.format("%.2f \u00b0C", (double)fuel.directEUbyDesintegration / 64.0)), centerX + 55, this.centerY - 12, ViewerCategory.TextAlign.CENTER, false, true, (Component)MIText.DirectHeatByDesintegration.text());
                break;
            }
            case 3: {
                int centerX = 66;
                int neutronNumber = 1;
                INuclearComponent<?> iNuclearComponent = recipe.nuclearComponent;
                if (iNuclearComponent instanceof NuclearFuel) {
                    NuclearFuel nuclearFuel = (NuclearFuel)iNuclearComponent;
                    neutronNumber = nuclearFuel.desintegrationMax;
                }
                widgets.text((Component)MIText.NeutronAbsorption.text(), this.centerX, this.centerY - 34, ViewerCategory.TextAlign.CENTER, false, true, null);
                widgets.drawable(guiGraphics -> {
                    int posX = centerX - 12;
                    int posY = this.centerY - 2;
                    guiGraphics.blit(PROGRESS_BAR, posX, posY, 0.0f, 0.0f, 40, 20, 40, 40);
                    guiGraphics.blit(PROGRESS_BAR, posX, posY, 0.0f, 20.0f, (int)((double)(40L * (System.currentTimeMillis() % 3000L)) / 3000.0), 20, 40, 40);
                });
                MutableComponent neutronNumberText = neutronNumber > 1 ? MIText.Neutrons.text(neutronNumber) : MIText.Neutron.text(neutronNumber);
                widgets.text((Component)neutronNumberText, this.centerX, this.centerY + 20, ViewerCategory.TextAlign.CENTER, false, true, null);
                break;
            }
            case 0: 
            case 1: {
                MutableComponent title;
                NeutronType type;
                int centerX = 66;
                if (recipe.type == CategoryType.FAST_NEUTRON_INTERACTION) {
                    type = NeutronType.FAST;
                    title = MIText.FastNeutron.text();
                    widgets.texture(TEXTURE_ATLAS, centerX - 53, this.centerY - 19, 0, 0, 88, 54);
                } else {
                    type = NeutronType.THERMAL;
                    title = MIText.ThermalNeutron.text();
                    widgets.texture(TEXTURE_ATLAS, centerX - 53, this.centerY - 19, 0, 54, 88, 54);
                }
                double interactionProb = recipe.nuclearComponent.getNeutronBehaviour().interactionTotalProbability(type);
                double scattering = recipe.nuclearComponent.getNeutronBehaviour().interactionRelativeProbability(type, NeutronInteraction.SCATTERING);
                double absorption = recipe.nuclearComponent.getNeutronBehaviour().interactionRelativeProbability(type, NeutronInteraction.ABSORPTION);
                widgets.text((Component)title, this.centerX, this.centerY - 34, ViewerCategory.TextAlign.CENTER, false, true, null);
                String scatteringString = String.format("%.1f ", 100.0 * interactionProb * scattering) + "%";
                String absorptionString = String.format("%.1f ", 100.0 * interactionProb * absorption) + "%";
                widgets.text((Component)Component.literal((String)scatteringString), centerX - 20, this.centerY - 15, ViewerCategory.TextAlign.CENTER, false, true, (Component)MIText.ScatteringProbability.text());
                widgets.text((Component)Component.literal((String)absorptionString).setStyle(TextHelper.NEUTRONS), centerX + 30, this.centerY + 35, ViewerCategory.TextAlign.CENTER, false, false, (Component)MIText.AbsorptionProbability.text());
                if (type != NeutronType.FAST) break;
                double slowingProba = recipe.nuclearComponent.getNeutronBehaviour().neutronSlowingProbability();
                String thermalFractionString = String.format("%.1f ", 100.0 * slowingProba) + "%";
                String fastFractionString = String.format("%.1f ", 100.0 * (1.0 - slowingProba)) + "%";
                widgets.text((Component)Component.literal((String)fastFractionString).setStyle(Style.EMPTY.withColor(12327450)), centerX + 60, this.centerY + 20, ViewerCategory.TextAlign.CENTER, false, false, (Component)MIText.FastNeutronFraction.text());
                widgets.text((Component)Component.literal((String)thermalFractionString).setStyle(Style.EMPTY.withColor(796583)), centerX + 60, this.centerY - 10, ViewerCategory.TextAlign.CENTER, false, false, (Component)MIText.ThermalNeutronFraction.text());
                int index = 1 + (int)Math.floor(slowingProba * 9.0);
                if (slowingProba == 0.0) {
                    index = 0;
                } else if (slowingProba == 1.0) {
                    index = 10;
                }
                widgets.texture(TEXTURE_ATLAS, centerX + 48, this.centerY, index * 16, 240, 16, 16);
            }
        }
    }

    @Override
    public ResourceLocation getRecipeId(Recipe recipe) {
        return INuclearComponent.getEmiRecipeId(recipe.nuclearComponent, "neutron_interaction", recipe.type.name().toLowerCase(Locale.ROOT));
    }

    public record Recipe(INuclearComponent<?> nuclearComponent, CategoryType type) {
    }

    public static enum CategoryType {
        FAST_NEUTRON_INTERACTION,
        THERMAL_NEUTRON_INTERACTION,
        FISSION,
        NEUTRON_PRODUCT;

    }
}

