/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.fluid;

import aztech.modern_industrialization.fluid.MIFluidBlock;
import aztech.modern_industrialization.fluid.MIFluidType;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidType;

public class MIFluid
extends Fluid {
    private final Supplier<MIFluidBlock> block;
    private final ItemLike bucketItem;
    private final Supplier<MIFluidType> fluidType;
    public final int color;

    public MIFluid(Supplier<MIFluidBlock> block, ItemLike bucketItem, Supplier<MIFluidType> fluidType, int color) {
        this.block = block;
        this.bucketItem = bucketItem;
        this.fluidType = fluidType;
        this.color = color;
    }

    public Item getBucket() {
        return this.bucketItem.asItem();
    }

    protected boolean canBeReplacedWith(FluidState state, BlockGetter world, BlockPos pos, Fluid fluid, Direction direction) {
        return true;
    }

    protected Vec3 getFlow(BlockGetter world, BlockPos pos, FluidState state) {
        return Vec3.ZERO;
    }

    public int getTickDelay(LevelReader world) {
        return 0;
    }

    protected float getExplosionResistance() {
        return 0.0f;
    }

    public float getHeight(FluidState state, BlockGetter world, BlockPos pos) {
        return 0.0f;
    }

    public float getOwnHeight(FluidState state) {
        return 0.0f;
    }

    protected BlockState createLegacyBlock(FluidState state) {
        return this.block.get().defaultBlockState();
    }

    public boolean isSource(FluidState state) {
        return true;
    }

    public int getAmount(FluidState state) {
        return 0;
    }

    public VoxelShape getShape(FluidState state, BlockGetter world, BlockPos pos) {
        return null;
    }

    public FluidType getFluidType() {
        return this.fluidType.get();
    }
}

