/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.inventory.ChangeListener;
import aztech.modern_industrialization.inventory.IConfigurableSlot;
import aztech.modern_industrialization.inventory.SlotConfig;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StoragePreconditions;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StorageView;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.base.ResourceAmount;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.SnapshotJournal;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import aztech.modern_industrialization.util.Simulation;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractConfigurableStack<T, K extends TransferVariant<T>>
extends SnapshotJournal<ResourceAmount<K>>
implements StorageView<K>,
IConfigurableSlot {
    private final Map<ChangeListener, Object> listeners = new IdentityHashMap<ChangeListener, Object>();
    protected K key = this.getBlankVariant();
    protected long amount = 0L;
    protected T lockedInstance = null;
    protected boolean playerLocked = false;
    protected boolean machineLocked = false;
    protected boolean playerLockable = true;
    protected boolean playerInsert = false;
    protected boolean playerExtract = true;
    protected boolean pipesInsert = false;
    protected boolean pipesExtract = false;

    public AbstractConfigurableStack() {
    }

    public AbstractConfigurableStack(AbstractConfigurableStack<T, K> other) {
        this.key = other.key;
        this.amount = other.amount;
        this.lockedInstance = other.lockedInstance;
        this.playerLocked = other.playerLocked;
        this.machineLocked = other.machineLocked;
        this.playerLockable = other.playerLockable;
        this.playerInsert = other.playerInsert;
        this.playerExtract = other.playerExtract;
        this.pipesInsert = other.pipesInsert;
        this.pipesExtract = other.pipesExtract;
    }

    public AbstractConfigurableStack(CompoundTag tag, HolderLookup.Provider registries) {
        this.key = this.readVariantFromNbt(tag.getCompound("key"), registries);
        this.amount = tag.getLong("amount");
        if (tag.contains("locked")) {
            this.lockedInstance = this.getRegistry().get(ResourceLocation.parse((String)tag.getString("locked")));
        }
        this.machineLocked = tag.getBoolean("machineLocked");
        this.playerLocked = tag.getBoolean("playerLocked");
        this.playerLockable = tag.getBoolean("playerLockable");
        this.playerInsert = tag.getBoolean("playerInsert");
        this.playerExtract = tag.getBoolean("playerExtract");
        this.pipesInsert = tag.getBoolean("pipesInsert");
        this.pipesExtract = tag.getBoolean("pipesExtract");
    }

    protected void notifyListeners() {
        ChangeListener.notify(this.listeners);
    }

    public void addListener(ChangeListener listener, Object token) {
        this.listeners.put(listener, token);
    }

    public void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract T getEmptyInstance();

    protected abstract K getBlankVariant();

    protected abstract Registry<T> getRegistry();

    protected abstract K readVariantFromNbt(CompoundTag var1, HolderLookup.Provider var2);

    protected abstract long getRemainingCapacityFor(K var1);

    public abstract long getTotalCapacityFor(T var1);

    @Override
    public SlotConfig getConfig() {
        return new SlotConfig(this.playerLockable, this.playerInsert, this.playerExtract, this.pipesInsert, this.pipesExtract);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConfigurableStack that = (AbstractConfigurableStack)o;
        return this.amount == that.amount && this.playerLocked == that.playerLocked && this.machineLocked == that.machineLocked && this.playerLockable == that.playerLockable && this.playerInsert == that.playerInsert && this.playerExtract == that.playerExtract && this.pipesInsert == that.pipesInsert && this.pipesExtract == that.pipesExtract && this.key.equals(that.key) && this.lockedInstance == that.lockedInstance;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.amount, this.lockedInstance, this.playerLocked, this.machineLocked, this.playerLockable, this.playerInsert, this.playerExtract, this.pipesInsert, this.pipesExtract);
    }

    public void setAmount(long amount) {
        this.amount = amount;
        if (amount == 0L) {
            this.key = this.getBlankVariant();
        }
        this.notifyListeners();
    }

    public void empty() {
        this.setAmount(0L);
    }

    public void increment(long amount) {
        this.setAmount(this.amount + amount);
    }

    public void decrement(long amount) {
        this.increment(-amount);
    }

    public void setKey(K key) {
        this.key = key;
        this.notifyListeners();
    }

    public boolean isResourceAllowedByLock(T instance) {
        return this.lockedInstance == null || this.lockedInstance == instance;
    }

    public boolean isResourceAllowedByLock(K key) {
        return this.isResourceAllowedByLock((K)key.getObject());
    }

    public boolean canPlayerInsert() {
        return this.playerInsert;
    }

    public boolean canPlayerExtract() {
        return this.playerExtract;
    }

    public boolean isPlayerLocked() {
        return this.playerLocked;
    }

    public boolean isMachineLocked() {
        return this.machineLocked;
    }

    public void enableMachineLock(T lockedInstance) {
        if (this.lockedInstance != null && lockedInstance != this.lockedInstance) {
            throw new RuntimeException("Trying to override locked instance from %s to %s".formatted(this.lockedInstance, lockedInstance));
        }
        this.machineLocked = true;
        this.lockedInstance = lockedInstance;
        this.notifyListeners();
    }

    public void disableMachineLock() {
        this.machineLocked = false;
        this.updatedLockedInstance();
    }

    public T getLockedInstance() {
        return this.lockedInstance;
    }

    public boolean isLockedTo(T otherInstance) {
        return this.getLockedInstance() == otherInstance;
    }

    public void togglePlayerLock() {
        if (this.playerLockable) {
            this.playerLocked = !this.playerLocked;
            this.updatedLockedInstance();
        }
    }

    public void togglePlayerLock(T cursorInstance) {
        if (this.playerLockable) {
            if (this.playerLocked && this.lockedInstance == this.getEmptyInstance() && cursorInstance != this.getEmptyInstance()) {
                this.lockedInstance = cursorInstance;
            } else {
                this.playerLocked = !this.playerLocked;
            }
            this.updatedLockedInstance();
        }
    }

    private void updatedLockedInstance() {
        if (!this.machineLocked && !this.playerLocked) {
            this.lockedInstance = null;
        } else if (this.lockedInstance == null) {
            this.lockedInstance = this.key.getObject();
        }
        this.notifyListeners();
    }

    public boolean canPlayerLock() {
        return this.playerLockable;
    }

    public static <T, K extends TransferVariant<T>> void playerLockNoOverride(T instance, long requiredAmount, List<? extends AbstractConfigurableStack<T, K>> stacks) {
        for (int iter = 0; iter < 2; ++iter) {
            boolean allowEmptyStacks = iter == 1;
            for (AbstractConfigurableStack<T, K> stack : stacks) {
                long capacity;
                if (stack.lockedInstance != null && stack.lockedInstance != stack.getEmptyInstance() || !stack.key.isOf(instance) && (!stack.isResourceBlank() || !allowEmptyStacks) || (capacity = stack.getTotalCapacityFor(instance)) <= 0L) continue;
                stack.lockedInstance = instance;
                stack.playerLocked = true;
                stack.notifyListeners();
                if ((requiredAmount -= capacity) > 0L) continue;
                return;
            }
        }
    }

    public boolean playerLock(T instance, Simulation simulation) {
        if (this.key.isBlank() || this.key.getObject() == instance) {
            if (simulation.isActing()) {
                this.lockedInstance = instance;
                this.playerLocked = true;
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    public boolean canPipesExtract() {
        return this.pipesExtract;
    }

    public boolean canPipesInsert() {
        return this.pipesInsert;
    }

    @Override
    public long extract(K key, long maxAmount, TransactionContext transaction) {
        if (this.pipesExtract) {
            return this.extractDirect(key, maxAmount, transaction);
        }
        return 0L;
    }

    public long extractDirect(K key, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(key, maxAmount);
        if (key.equals(this.key)) {
            long extracted = Math.min(this.amount, maxAmount);
            this.updateSnapshots(transaction);
            this.decrement(extracted);
            return extracted;
        }
        return 0L;
    }

    @Override
    public boolean isResourceBlank() {
        return this.key.isBlank();
    }

    public boolean isEmpty() {
        return this.isResourceBlank();
    }

    @Override
    public K getResource() {
        return this.key;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public ResourceAmount<K> createSnapshot() {
        return new ResourceAmount<K>(this.key, this.amount);
    }

    @Override
    public void revertToSnapshot(ResourceAmount<K> ra) {
        this.amount = ra.amount();
        this.key = (TransferVariant)ra.resource();
    }

    @Override
    protected void onRootCommit(ResourceAmount<K> originalState) {
        this.notifyListeners();
    }

    public CompoundTag toNbt(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.put("key", this.key.toNbt(registries));
        tag.putLong("amount", this.amount);
        if (this.lockedInstance != null) {
            tag.putString("locked", this.getRegistry().getKey(this.lockedInstance).toString());
        }
        tag.putBoolean("machineLocked", this.machineLocked);
        tag.putBoolean("playerLocked", this.playerLocked);
        tag.putBoolean("playerLockable", this.playerLockable);
        tag.putBoolean("playerInsert", this.playerInsert);
        tag.putBoolean("playerExtract", this.playerExtract);
        tag.putBoolean("pipesInsert", this.pipesInsert);
        tag.putBoolean("pipesExtract", this.pipesExtract);
        return tag;
    }
}

