/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.api.datamaps.MIDataMaps;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.FluidHelper;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;

public interface FluidFuelItemHelper {
    public static FluidVariant getFluid(ItemStack stack) {
        return FluidVariant.of(new ItemStorage(stack, 0).getFluid());
    }

    public static int getAmount(ItemStack stack) {
        return new ItemStorage(stack, 0).getFluid().getAmount();
    }

    public static void decrement(ItemStack stack) {
        new ItemStorage(stack, 0).drain(1, IFluidHandler.FluidAction.EXECUTE);
    }

    public static void appendTooltip(ItemStack stack, List<Component> tooltip, long capacity) {
        Style style = Style.EMPTY.withColor(TextColor.fromRgb((int)0xA9A9A9)).withItalic(Boolean.valueOf(true));
        FluidVariant fluid = FluidFuelItemHelper.getFluid(stack);
        tooltip.add(FluidHelper.getFluidName(fluid, true));
        if (!fluid.isBlank()) {
            tooltip.add((Component)FluidHelper.getFluidAmount(FluidFuelItemHelper.getAmount(stack), capacity).setStyle(style));
        }
    }

    public static class ItemStorage
    extends FluidHandlerItemStack {
        public ItemStorage(ItemStack container, int capacity) {
            super(MIComponents.FLUID_CONTENT, container, capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluidHolder().getData(MIDataMaps.FLUID_FUELS) != null;
        }

        protected void setFluid(FluidStack fluid) {
            if (fluid.isEmpty()) {
                this.setContainerToEmpty();
            } else {
                super.setFluid(fluid);
            }
        }
    }
}

