/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.blocks.FastBlockEntity;
import aztech.modern_industrialization.blocks.WrenchableBlockEntity;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.ComponentStorage;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineOverlay;
import aztech.modern_industrialization.machines.components.DropableComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.PlacedByComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.gui.MachineMenuServer;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public abstract class MachineBlockEntity
extends FastBlockEntity
implements MenuProvider,
WrenchableBlockEntity {
    public final ComponentStorage.GuiServer guiComponents = new ComponentStorage.GuiServer();
    public final ComponentStorage.Server components = new ComponentStorage.Server();
    public final MachineGuiParameters guiParams;
    private boolean syncCausesRemesh = true;
    private Boolean hasRedstoneHighSignal = null;
    public final OrientationComponent orientation;
    public final PlacedByComponent placedBy;

    public MachineBlockEntity(BEP bep, MachineGuiParameters guiParams, OrientationComponent.Params orientationParams) {
        super(bep.type(), bep.pos(), bep.state());
        this.guiParams = guiParams;
        this.orientation = new OrientationComponent(orientationParams, this);
        this.placedBy = new PlacedByComponent();
        this.registerComponents(this.orientation, this.placedBy);
    }

    protected final void registerGuiComponent(GuiComponent.Server ... components) {
        this.guiComponents.register(components);
    }

    protected final void registerComponents(IComponent ... components) {
        this.components.register(components);
    }

    public abstract MIInventory getInventory();

    public final Component getDisplayName() {
        return Component.translatable((String)Util.makeDescriptionId((String)"block", (ResourceLocation)this.guiParams.blockId));
    }

    public final AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new MachineMenuServer(syncId, inv, this, this.guiParams);
    }

    public final void writeScreenOpeningData(RegistryFriendlyByteBuf buf) {
        MIInventory inv = this.getInventory();
        CompoundTag tag = new CompoundTag();
        NbtHelper.putList(tag, "items", inv.getItemStacks(), configurableItemStack -> configurableItemStack.toNbt((HolderLookup.Provider)buf.registryAccess()));
        NbtHelper.putList(tag, "fluids", inv.getFluidStacks(), configurableFluidStack -> configurableFluidStack.toNbt((HolderLookup.Provider)buf.registryAccess()));
        buf.writeNbt((Tag)tag);
        inv.itemPositions.write((FriendlyByteBuf)buf);
        inv.fluidPositions.write((FriendlyByteBuf)buf);
        buf.writeInt(this.guiComponents.size());
        for (GuiComponent.Server component : this.guiComponents) {
            buf.writeResourceLocation(component.getId());
            component.writeInitialData(buf);
        }
        this.guiParams.write((FriendlyByteBuf)buf);
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void openMenu(ServerPlayer player) {
        player.openMenu((MenuProvider)this, this::writeScreenOpeningData);
    }

    protected abstract MachineModelClientData getMachineModelData();

    @MustBeInvokedByOverriders
    public void onPlaced(@Nullable LivingEntity placer, ItemStack itemStack) {
        this.orientation.onPlaced(placer, itemStack);
        this.placedBy.onPlaced(placer);
    }

    @Override
    public boolean useWrench(Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.orientation.useWrench(player, hand, MachineOverlay.findHitSide(hitResult))) {
            this.getLevel().blockUpdated(this.getBlockPos(), Blocks.AIR);
            this.setChanged();
            if (!this.getLevel().isClientSide()) {
                this.sync();
            }
            return true;
        }
        return false;
    }

    public final ModelData getModelData() {
        return ModelData.builder().with(MachineModelClientData.KEY, (Object)this.getMachineModelData()).build();
    }

    @Override
    public void sync() {
        this.sync(true);
    }

    public void sync(boolean forceRemesh) {
        this.syncCausesRemesh = this.syncCausesRemesh || forceRemesh;
        super.sync();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("remesh", this.syncCausesRemesh);
        this.syncCausesRemesh = false;
        for (IComponent component : this.components) {
            component.writeClientNbt(tag, registries);
        }
        return tag;
    }

    public final void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        for (IComponent component : this.components) {
            component.writeNbt(tag, registries);
        }
    }

    public final void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.load(tag, registries, false);
    }

    public final void load(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        if (!tag.contains("remesh")) {
            for (IComponent component : this.components) {
                component.readNbt(tag, registries, isUpgradingMachine);
            }
        } else {
            boolean forceChunkRemesh = tag.getBoolean("remesh");
            for (IComponent component : this.components) {
                component.readClientNbt(tag, registries);
            }
            if (forceChunkRemesh) {
                WorldHelper.forceChunkRemesh(this.level, this.worldPosition);
                this.requestModelDataUpdate();
            }
        }
    }

    @Override
    protected final boolean shouldSkipComparatorUpdate() {
        return !this.hasComparatorOutput();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static void registerItemApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, bet, (be, direction) -> ((MachineBlockEntity)be).getInventory().itemStorage.itemHandler));
    }

    public static void registerFluidApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, bet, (be, direction) -> ((MachineBlockEntity)be).getInventory().fluidStorage.fluidHandler));
    }

    public List<ItemStack> dropExtra() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        this.components.forType(DropableComponent.class, u -> drops.add(u.getDrop()));
        return drops;
    }

    public List<Component> getTooltips() {
        return List.of();
    }

    protected boolean hasComparatorOutput() {
        return false;
    }

    protected int getComparatorOutput() {
        return 0;
    }

    public boolean hasRedstoneHighSignal() {
        if (this.hasRedstoneHighSignal == null) {
            this.refreshRedstoneStatus();
        }
        return this.hasRedstoneHighSignal;
    }

    void refreshRedstoneStatus() {
        this.hasRedstoneHighSignal = this.level.hasNeighborSignal(this.worldPosition);
    }
}

