/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.AbstractWaterPumpBlockEntity;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Simulation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SteamWaterPumpBlockEntity
extends AbstractWaterPumpBlockEntity {
    public final boolean bronze;
    private final MIInventory inventory;

    public SteamWaterPumpBlockEntity(BEP bep, boolean bronze) {
        super(bep, bronze ? "bronze_water_pump" : "steel_water_pump");
        this.bronze = bronze;
        long capacity = 1000 * (bronze ? 8 : 16);
        List<ConfigurableFluidStack> fluidStacks = Arrays.asList(ConfigurableFluidStack.lockedInputSlot(capacity, MIFluids.STEAM.asFluid()), ConfigurableFluidStack.lockedOutputSlot(capacity, (Fluid)Fluids.WATER));
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(21, 30).addSlot(110, 30).build();
        this.inventory = new MIInventory(Collections.emptyList(), fluidStacks, SlotPositions.empty(), fluidPositions);
        this.registerComponents(this.inventory);
    }

    @Override
    protected long consumeEu(long max) {
        return SteamHelper.consumeSteamEu(this.inventory.getFluidStacks(), max, Simulation.ACT);
    }

    @Override
    protected int getWaterMultiplier() {
        return this.bronze ? 1 : 2;
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }
}

