/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.nuclear.INuclearTileData;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class NuclearReactorGui {
    private static final double neutronsMax = 8192.0;

    public static double neutronColorScheme(double neutronNumber) {
        neutronNumber = Math.min(neutronNumber, 8192.0);
        return Math.log(1.0 + 10.0 * neutronNumber) / Math.log(81921.0);
    }

    public record Data(boolean valid, int gridSizeX, int gridSizeY, Optional<INuclearTileData>[] tilesData, double euProduction, double euFuelConsumption) {
        public int toIndex(int x, int y) {
            return Data.toIndex(x, y, this.gridSizeY);
        }

        public static int toIndex(int x, int y, int sizeY) {
            return x * sizeY + y;
        }
    }

    public record Server(Supplier<Data> dataSupplier) implements GuiComponent.Server<Data>
    {
        @Override
        public Data copyData() {
            return this.dataSupplier.get();
        }

        @Override
        public boolean needsSync(Data cachedData) {
            Data data = this.copyData();
            if (data.valid != cachedData.valid || data.gridSizeX != cachedData.gridSizeX || data.gridSizeY != cachedData.gridSizeY || data.euProduction != cachedData.euProduction || data.euFuelConsumption != cachedData.euFuelConsumption) {
                return true;
            }
            for (int i = 0; i < data.gridSizeY * data.gridSizeX; ++i) {
                if (!INuclearTileData.areEquals(data.tilesData[i], cachedData.tilesData[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public void writeInitialData(RegistryFriendlyByteBuf buf) {
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(RegistryFriendlyByteBuf buf) {
            Data data = this.copyData();
            buf.writeBoolean(data.valid);
            if (data.valid) {
                buf.writeInt(data.gridSizeX);
                buf.writeInt(data.gridSizeY);
                for (Optional<INuclearTileData> tiles : data.tilesData) {
                    INuclearTileData.write(tiles, buf);
                }
                buf.writeDouble(data.euProduction);
                buf.writeDouble(data.euFuelConsumption);
            }
        }

        @Override
        public ResourceLocation getId() {
            return GuiComponents.NUCLEAR_REACTOR_GUI;
        }
    }
}

