/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.init;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.datagen.model.MachineModelsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.util.MobSpawning;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class MachineRegistrationHelper {
    @SafeVarargs
    public static Supplier<BlockEntityType<?>> registerMachine(String englishName, String id, Function<BEP, MachineBlockEntity> factory, Consumer<BlockEntityType<?>> ... extraRegistrators) {
        BlockEntityType[] bet = new BlockEntityType[1];
        BiFunction<BlockPos, BlockState, MachineBlockEntity> ctor = (pos, state) -> (MachineBlockEntity)factory.apply(new BEP((BlockEntityType<?>)bet[0], (BlockPos)pos, (BlockState)state));
        BlockDefinition<MachineBlock> blockDefinition = MIBlock.block(englishName, id, MIBlock.BlockDefinitionParams.defaultStone().sortOrder(SortOrder.MACHINES).withBlockConstructor(s -> new MachineBlock(ctor, (BlockBehaviour.Properties)s)).withModel((block, gen) -> {}).isValidSpawn(MobSpawning.NO_SPAWN).isRedstoneConductor(Blocks::never));
        return MIRegistries.BLOCK_ENTITIES.register(id, () -> {
            Object block = blockDefinition.asBlock();
            bet[0] = BlockEntityType.Builder.of(ctor::apply, (Block[])new Block[]{block}).build(null);
            for (Consumer extraRegistrator : extraRegistrators) {
                extraRegistrator.accept(bet[0]);
            }
            return bet[0];
        });
    }

    public static void addMachineModel(String tier, String id, String machineType, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        MachineCasing defaultCasing;
        if (tier.equals("bronze")) {
            defaultCasing = MachineCasings.BRONZE;
        } else if (tier.equals("steel")) {
            defaultCasing = MachineCasings.STEEL;
        } else if (tier.equals("electric")) {
            defaultCasing = CableTier.LV.casing;
        } else {
            throw new RuntimeException("Invalid tier: " + tier);
        }
        MachineRegistrationHelper.addMachineModel(id, machineType, defaultCasing, frontOverlay, topOverlay, sideOverlay);
    }

    public static void addMachineModel(String id, String overlayFolder, MachineCasing defaultCasing, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        MachineRegistrationHelper.addMachineModel(id, overlayFolder, defaultCasing, frontOverlay, topOverlay, sideOverlay, true);
    }

    public static void addMachineModel(String id, String overlayFolder, MachineCasing defaultCasing, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, boolean hasActive) {
        MachineModelsToGenerate.register(id, defaultCasing, overlayFolder, frontOverlay, topOverlay, sideOverlay, hasActive);
    }

    public static void addModelsForTiers(String name, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, String ... tiers) {
        for (String tier : tiers) {
            MachineRegistrationHelper.addMachineModel(tier, tier + "_" + name, name, frontOverlay, topOverlay, sideOverlay);
        }
    }
}

