/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.misc.runtime_datagen;

import aztech.modern_industrialization.MI;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.DetectedVersion;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.registries.VanillaRegistries;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class RuntimeDataGen {
    public static void run(IDataGenConfig ... configs) {
        try {
            RuntimeDataGen.runInner(configs);
        }
        catch (Exception ex) {
            MI.LOGGER.error("Failed to runtime datagen", (Throwable)ex);
        }
    }

    private static void runInner(IDataGenConfig ... configs) throws Exception {
        Path miFolder = FMLPaths.GAMEDIR.get().resolve("modern_industrialization");
        Path datagenOverridesFolder = miFolder.resolve("extra_datagen_resources");
        Files.createDirectories(datagenOverridesFolder.resolve("assets").resolve("modern_industrialization").resolve("textures"), new FileAttribute[0]);
        Files.createDirectories(datagenOverridesFolder.resolve("assets").resolve("modern_industrialization").resolve("datagen_texture_overrides"), new FileAttribute[0]);
        Path dataOutput = miFolder.resolve("runtime_datagen");
        MI.LOGGER.info("Starting MI runtime data generation");
        ModFileInfo modContainer = LoadingModList.get().getModFileById("modern_industrialization");
        CompletableFuture<HolderLookup.Provider> registriesFuture = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        DataGenerator gen = new DataGenerator(dataOutput, DetectedVersion.tryDetectVersion(), true);
        for (IDataGenConfig config : configs) {
            config.run(gen, new ExistingFileHelper(List.of(), Set.of(), false, null, null), registriesFuture, true, true);
        }
        gen.run();
        MI.LOGGER.info("Starting MI runtime pack calculation");
        Path cleanedOutput = miFolder.resolve("generated_resources");
        if (Files.exists(cleanedOutput, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(cleanedOutput, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        try (Stream<Path> cacheStream = Files.walk(dataOutput.resolve(".cache"), 1, new FileVisitOption[0]);){
            cacheStream.forEach(cachePath -> {
                if (Files.isDirectory(cachePath, new LinkOption[0])) {
                    return;
                }
                Map<String, String> newCache = RuntimeDataGen.readCache(cachePath);
                Map<String, String> oldCache = RuntimeDataGen.readCache(modContainer.getFile().findResource(new String[]{".cache/" + String.valueOf(cachePath.getFileName())}));
                for (Map.Entry<String, String> newEntry : newCache.entrySet()) {
                    String oldHash = oldCache.get(newEntry.getKey());
                    if (newEntry.getValue().equals(oldHash)) continue;
                    Path newPath = cleanedOutput.resolve(newEntry.getKey());
                    try {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                        Files.copy(dataOutput.resolve(newEntry.getKey()), newPath, new CopyOption[0]);
                    }
                    catch (IOException e) {
                        MI.LOGGER.error("Failed to copy file " + newEntry.getKey(), (Throwable)e);
                    }
                }
            });
        }
        MI.LOGGER.info("Successfully finished MI runtime data generation");
    }

    private static Map<String, String> readCache(Path path) {
        HashMap<String, String> hashMap;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                reader.readLine();
                reader.lines().forEach(line -> {
                    String[] parts = line.split(" ", 2);
                    map.put(parts[1], parts[0]);
                });
                hashMap = map;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    MI.LOGGER.warn("Failed to read cache file " + String.valueOf(path), (Throwable)e);
                    return Map.of();
                }
            }
            reader.close();
        }
        return hashMap;
    }

    @FunctionalInterface
    public static interface IDataGenConfig {
        public void run(DataGenerator var1, ExistingFileHelper var2, CompletableFuture<HolderLookup.Provider> var3, boolean var4, boolean var5);
    }
}

